/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core.v2_0.credential;

import java.io.IOException;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import tecgraf.openbus.core.v2_0.EncryptedBlockHelper;
import tecgraf.openbus.core.v2_0.HashValueHelper;
import tecgraf.openbus.core.v2_0.IdentifierHelper;
import tecgraf.openbus.core.v2_0.OctetSeqHelper;
import tecgraf.openbus.core.v2_0.credential.CredentialData;
import tecgraf.openbus.core.v2_0.credential.SignedCallChainHelper;

public abstract class CredentialDataHelper {
    private static volatile TypeCode _type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeCode type() {
        if (_type != null) return _type;
        Class<CredentialDataHelper> clazz = CredentialDataHelper.class;
        synchronized (CredentialDataHelper.class) {
            if (_type != null) return _type;
            _type = ORB.init().create_struct_tc(CredentialDataHelper.id(), "CredentialData", new StructMember[]{new StructMember("bus", ORB.init().create_alias_tc(IdentifierHelper.id(), "Identifier", ORB.init().create_string_tc(0)), null), new StructMember("login", ORB.init().create_alias_tc(IdentifierHelper.id(), "Identifier", ORB.init().create_string_tc(0)), null), new StructMember("session", ORB.init().get_primitive_tc(TCKind.from_int(5)), null), new StructMember("ticket", ORB.init().get_primitive_tc(TCKind.from_int(5)), null), new StructMember("hash", ORB.init().create_alias_tc(HashValueHelper.id(), "HashValue", ORB.init().create_array_tc(32, ORB.init().get_primitive_tc(TCKind.from_int(10)))), null), new StructMember("chain", ORB.init().create_struct_tc(SignedCallChainHelper.id(), "SignedCallChain", new StructMember[]{new StructMember("signature", ORB.init().create_alias_tc(EncryptedBlockHelper.id(), "EncryptedBlock", ORB.init().create_array_tc(256, ORB.init().get_primitive_tc(TCKind.from_int(10)))), null), new StructMember("encoded", ORB.init().create_alias_tc(OctetSeqHelper.id(), "OctetSeq", ORB.init().create_sequence_tc(0, ORB.init().get_primitive_tc(TCKind.from_int(10)))), null)}), null)});
            // ** MonitorExit[var0] (shouldn't be in output)
            return _type;
        }
    }

    public static void insert(Any any, CredentialData s) {
        any.type(CredentialDataHelper.type());
        CredentialDataHelper.write(any.create_output_stream(), s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CredentialData extract(Any any) {
        InputStream in = any.create_input_stream();
        try {
            CredentialData credentialData = CredentialDataHelper.read(in);
            return credentialData;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception " + e.toString());
            }
        }
    }

    public static String id() {
        return "IDL:tecgraf/openbus/core/v2_0/credential/CredentialData:1.0";
    }

    public static CredentialData read(InputStream in) {
        CredentialData result = new CredentialData();
        result.bus = in.read_string();
        result.login = in.read_string();
        result.session = in.read_ulong();
        result.ticket = in.read_ulong();
        result.hash = HashValueHelper.read(in);
        result.chain = SignedCallChainHelper.read(in);
        return result;
    }

    public static void write(OutputStream out, CredentialData s) {
        String tmpResult0 = s.bus;
        out.write_string(tmpResult0);
        String tmpResult1 = s.login;
        out.write_string(tmpResult1);
        out.write_ulong(s.session);
        out.write_ulong(s.ticket);
        HashValueHelper.write(out, s.hash);
        SignedCallChainHelper.write(out, s.chain);
    }
}

