package busexplorer.exception.handling;

/**
 * Esta classe atua como um wrapper sobre as excees especficas que desejamos
 * tratar.
 * 
 * @author Tecgraf
 * @param <T> a enumerao de tipos de excees a serem tratadas.
 */
public abstract class HandlingException<T extends Enum<?>> {

  /** A exceo */
  private Exception theException;

  /** O tipo */
  private T theType;

  /** O contexto */
  private ExceptionContext theContext;

  /**
   * Construtor.
   * 
   * @param exception a exceo
   * @param context o contexto
   */
  public HandlingException(Exception exception, ExceptionContext context) {
    this.theException = exception;
    this.theType = getTypeFromException(exception);
    this.theContext = context;
  }

  /**
   * Recuper o tipo enum da exceo.
   * 
   * @param exception exceo
   * @return o tipo Enum da exceo.
   */
  protected abstract T getTypeFromException(Exception exception);

  /**
   * Recupera a exceo
   * 
   * @return a exceo
   */
  public Exception getException() {
    return theException;
  }

  /**
   * Recupera o contexto
   * 
   * @return o contexto
   */
  public ExceptionContext getContext() {
    return theContext;
  }

  /**
   * Recupera o tipo da exceo
   * 
   * @return o tipo
   */
  public T getType() {
    return theType;
  }

}