/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.configuration.admins;

import busexplorer.Application;
import busexplorer.desktop.dialog.InputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.configuration.admins.AdminWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;

public class AdminDeleteAction
extends OpenBusAction<AdminWrapper> {
    public AdminDeleteAction(JFrame parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REMOVE;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (InputDialog.showConfirmDialog(this.parentWindow, this.getString("confirm.msg"), this.getString("confirm.title")) != 0) {
            return;
        }
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                ArrayList<String> revoke = new ArrayList<String>();
                List admins = AdminDeleteAction.this.getTablePanelComponent().getSelectedElements();
                for (AdminWrapper admin : admins) {
                    revoke.add(admin.getAdmin());
                }
                Application.login().admin.revokeAdminFrom(revoke);
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    AdminDeleteAction.this.getTablePanelComponent().removeSelectedElements();
                    AdminDeleteAction.this.getTablePanelComponent().refresh(null);
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

