/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.entities;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.entities.EntityInputDialog;
import busexplorer.panel.entities.EntityWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.EntityCategoryDesc;

public class EntityAddAction
extends OpenBusAction<EntityWrapper> {
    public EntityAddAction(JFrame parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ADD;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        BusExplorerTask<List<EntityCategoryDesc>> task = new BusExplorerTask<List<EntityCategoryDesc>>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                this.setResult(Application.login().admin.getCategories());
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    List result = (List)this.getResult();
                    if (result.size() == 0) {
                        StandardDialogs.showErrorDialog(this.parentWindow, EntityAddAction.this.getString("error.title"), EntityAddAction.this.getString("error.noCategories.msg"));
                    } else {
                        new EntityInputDialog(EntityAddAction.this.parentWindow, EntityAddAction.this.getTablePanelComponent(), (List)this.getResult()).showDialog();
                    }
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

