/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.healing;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.integrations.IntegrationDeleteAction;
import busexplorer.panel.integrations.IntegrationEditAction;
import busexplorer.panel.integrations.IntegrationRefreshAction;
import busexplorer.panel.integrations.IntegrationTableProvider;
import busexplorer.panel.integrations.IntegrationWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JFrame;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.openbus.services.governance.v1_0.Integration;

public class IntegrationMissingBasicInformation
extends IntegrationRefreshAction {
    private Consumer<TablePanelComponent> updateReportHook = null;

    public IntegrationMissingBasicInformation(JFrame parentWindow) {
        super(parentWindow);
    }

    public IntegrationMissingBasicInformation(JFrame parentWindow, Consumer<TablePanelComponent> updateReportHook) {
        this(parentWindow);
        this.updateReportHook = updateReportHook;
    }

    protected TablePanelComponent<IntegrationWrapper> buildTableComponent() {
        if (this.getTablePanelComponent() == null) {
            ArrayList<OpenBusAction> actions = new ArrayList<OpenBusAction>();
            actions.add(new IntegrationDeleteAction((JFrame)this.parentWindow));
            actions.add(new IntegrationEditAction((JFrame)this.parentWindow));
            actions.add(this);
            this.setTablePanelComponent(new TablePanelComponent<IntegrationWrapper>(new ObjectTableModel<IntegrationWrapper>(new ArrayList(), new IntegrationTableProvider()), actions, false, true));
        }
        return this.getTablePanelComponent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getTablePanelComponent().getElements().clear();
        if (!Application.login().extension.isExtensionCapable()) {
            return;
        }
        BusExplorerTask<List<IntegrationWrapper>> task = new BusExplorerTask<List<IntegrationWrapper>>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                int i = 0;
                ArrayList<Integration> result = new ArrayList<Integration>();
                List<Integration> integrations = Application.login().extension.getIntegrations();
                for (Integration integration : integrations) {
                    if (integration.consumer() == null || integration.provider() == null || integration.contracts().length == 0) {
                        result.add(integration);
                    }
                    this.setProgressStatus(100 * i / integrations.size());
                    ++i;
                }
                this.setResult(IntegrationWrapper.convertToInfo(result));
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    TablePanelComponent tablePanelComponent = IntegrationMissingBasicInformation.this.getTablePanelComponent();
                    if (((List)this.getResult()).isEmpty() && IntegrationMissingBasicInformation.this.updateReportHook != null && tablePanelComponent.getParent() != null) {
                        IntegrationMissingBasicInformation.this.updateReportHook.accept(tablePanelComponent);
                    } else {
                        tablePanelComponent.setElements((List)this.getResult());
                    }
                }
            }
        };
        task.execute(this.parentWindow, Language.get(this.getClass().getSuperclass(), "waiting.title"), Language.get(this.getClass().getSuperclass(), "waiting.msg"), 2, 0, true, false);
    }
}

