/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.interfaces;

import busexplorer.Application;
import busexplorer.desktop.dialog.ConsistencyValidationDialog;
import busexplorer.desktop.dialog.InputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.authorizations.AuthorizationWrapper;
import busexplorer.panel.contracts.ContractDeleteAction;
import busexplorer.panel.contracts.ContractWrapper;
import busexplorer.panel.interfaces.InterfaceWrapper;
import busexplorer.panel.offers.OfferWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.ConsistencyValidationResult;
import busexplorer.utils.Language;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceProperty;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntity;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntityDesc;
import tecgraf.openbus.services.governance.v1_0.Contract;

public class InterfaceDeleteAction
extends OpenBusAction<InterfaceWrapper> {
    public InterfaceDeleteAction(JFrame parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REMOVE;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (InputDialog.showConfirmDialog(this.parentWindow, this.getString("confirm.msg"), this.getString("confirm.title")) != 0) {
            return;
        }
        ConsistencyValidationDialog.DeleteOptions removeFlags = new ConsistencyValidationDialog.DeleteOptions();
        ConsistencyValidationResult consistencyValidationResult = new ConsistencyValidationResult();
        List<InterfaceWrapper> interfaces = this.getTablePanelComponent().getSelectedElements();
        BusExplorerTask<Void> deleteInterfaceTask = InterfaceDeleteAction.DeleteInterfaceTask(interfaces, this.getTablePanelComponent()::removeSelectedElements, removeFlags, consistencyValidationResult);
        Runnable effectiveDeletion = () -> deleteInterfaceTask.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0, true, false);
        if (InterfaceDeleteAction.ExecuteAllDependencyCheckTasks(this.parentWindow, interfaces, consistencyValidationResult)) {
            if (consistencyValidationResult.isEmpty()) {
                effectiveDeletion.run();
            } else {
                new ConsistencyValidationDialog(this.parentWindow, this.getString("confirm.title"), this.getClass(), consistencyValidationResult, removeFlags, effectiveDeletion).showDialog();
            }
        }
    }

    public static boolean ExecuteAllDependencyCheckTasks(Window parentWindow, Collection<InterfaceWrapper> interfaces, ConsistencyValidationResult consistencyValidationResult) {
        String title = Language.get(ConsistencyValidationDialog.class, "waiting.dependency.title");
        String waitingMessage = Language.get(InterfaceDeleteAction.class, "waiting.dependency.msg");
        BusExplorerTask<Void> governanceDependencyCheckTask = InterfaceDeleteAction.GovernanceDependencyCheckTask(interfaces, consistencyValidationResult);
        BusExplorerTask<Void> extensionDependencyCheckTask = InterfaceDeleteAction.ExtensionDependencyCheckTask(interfaces, consistencyValidationResult);
        governanceDependencyCheckTask.execute(parentWindow, title, waitingMessage, 2, 0, true, false);
        extensionDependencyCheckTask.execute(parentWindow, title, waitingMessage, 2, 0, true, false);
        return extensionDependencyCheckTask.getStatus() && governanceDependencyCheckTask.getStatus() && ContractDeleteAction.ExecuteAllDependencyCheckTasks(parentWindow, consistencyValidationResult.getInconsistentContracts().values(), consistencyValidationResult);
    }

    public static BusExplorerTask<Void> GovernanceDependencyCheckTask(final Collection<InterfaceWrapper> interfaces, final ConsistencyValidationResult consistencyValidationResult) {
        return new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                this.setProgressDialogEnabled(true);
                int i = 0;
                int step = 50;
                List<ServiceOfferDesc> offers = Application.login().admin.getOffers();
                for (ServiceOfferDesc offer : offers) {
                    block1: for (InterfaceWrapper interfaceWrapper : interfaces) {
                        for (ServiceProperty property : offer.properties) {
                            if (!property.name.equals("openbus.component.interface") || !property.value.equals(interfaceWrapper.getName())) continue;
                            RegisteredEntity entity = Application.login().admin.getEntity(offer.ref.owner().entity);
                            consistencyValidationResult.getInconsistentAuthorizations().add(new AuthorizationWrapper(entity.describe(), interfaceWrapper.getName()));
                            consistencyValidationResult.getInconsistentOffers().add(new OfferWrapper(offer));
                            continue block1;
                        }
                    }
                    this.setProgressStatus(step * i / offers.size());
                    ++i;
                }
                i = 0;
                Map<RegisteredEntityDesc, List<String>> authorizations = Application.login().admin.getAuthorizations();
                int authorizationsSum = 0;
                for (List list : authorizations.values()) {
                    authorizationsSum += list.size();
                }
                block4: for (Map.Entry entry : authorizations.entrySet()) {
                    for (String grantedInterface : (List)entry.getValue()) {
                        if (interfaces.contains(new InterfaceWrapper(grantedInterface))) {
                            AuthorizationWrapper authWrapper = new AuthorizationWrapper((RegisteredEntityDesc)entry.getKey(), grantedInterface);
                            if (!consistencyValidationResult.getInconsistentAuthorizations().contains(authWrapper)) {
                                consistencyValidationResult.getInconsistentAuthorizations().add(authWrapper);
                                continue block4;
                            }
                        }
                        this.setProgressStatus(step + step * i / authorizationsSum);
                        ++i;
                    }
                }
            }
        };
    }

    public static BusExplorerTask<Void> ExtensionDependencyCheckTask(final Collection<InterfaceWrapper> interfaces, final ConsistencyValidationResult consistencyValidationResult) {
        return new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                this.setProgressDialogEnabled(true);
                int i = 0;
                if (Application.login().extension.isExtensionCapable()) {
                    LinkedHashMap contractsMaybeBroken = new LinkedHashMap();
                    for (InterfaceWrapper interfaceWrapper : interfaces) {
                        for (Contract contract : Application.login().extension.getContracts()) {
                            ContractWrapper contractWrapper = new ContractWrapper(contract);
                            String iface = interfaceWrapper.getName();
                            if (!contractWrapper.interfaces().contains(iface)) continue;
                            if (contractsMaybeBroken.get(contractWrapper.name()) == null) {
                                contractsMaybeBroken.put(contractWrapper.name(), new ArrayList());
                            }
                            ((List)contractsMaybeBroken.get(contractWrapper.name())).add(iface);
                        }
                        this.setProgressStatus(70 * i / interfaces.size());
                        ++i;
                    }
                    i = 0;
                    for (Map.Entry entry : contractsMaybeBroken.entrySet()) {
                        Contract contract = Application.login().extension.getContractRegistry().get((String)entry.getKey());
                        ContractWrapper wrapper = new ContractWrapper(contract);
                        if (wrapper.interfaces().size() == ((List)entry.getValue()).size()) {
                            consistencyValidationResult.getInconsistentContracts().put(wrapper.name(), wrapper);
                        }
                        this.setProgressStatus(70 + 30 * i / contractsMaybeBroken.entrySet().size());
                        ++i;
                    }
                }
            }
        };
    }

    public static BusExplorerTask<Void> DeleteInterfaceTask(final Collection<InterfaceWrapper> interfaces, final Runnable delegateAfterTaskUI, final ConsistencyValidationDialog.DeleteOptions removeFlags, final ConsistencyValidationResult consistencyValidationResult) {
        return new BusExplorerTask<Void>(ExceptionContext.BusCore){
            private final String removeDependenciesTitle;
            private final String removeDependenciesMessage;
            {
                super(context);
                this.removeDependenciesTitle = Language.get(InterfaceDeleteAction.class, "waiting.removing.dependencies.title");
                this.removeDependenciesMessage = Language.get(InterfaceDeleteAction.class, "waiting.removing.dependencies.msg");
            }

            @Override
            protected void doPerformTask() throws Exception {
                int i = 0;
                int step = 25;
                if (Application.login().extension.isExtensionCapable()) {
                    if (removeFlags.isFullyGovernanceRemoval() && !consistencyValidationResult.getInconsistentContracts().isEmpty()) {
                        ContractDeleteAction.DeleteContractTask(consistencyValidationResult.getInconsistentContracts().values(), null, removeFlags, consistencyValidationResult).execute(this.parentWindow, this.removeDependenciesTitle, this.removeDependenciesMessage, 2, 0, true, false);
                    }
                    for (InterfaceWrapper interfaceInfo : interfaces) {
                        block3: for (Contract contract : Application.login().extension.getContracts()) {
                            String[] interfaceContractList;
                            for (String inContract : interfaceContractList = contract.interfaces()) {
                                if (!inContract.equals(interfaceInfo.getName())) continue;
                                contract.removeInterface(inContract);
                                continue block3;
                            }
                        }
                        this.setProgressStatus(step * i / interfaces.size());
                        ++i;
                    }
                }
                i = 0;
                if (removeFlags.isFullyGovernanceRemoval()) {
                    Set<OfferWrapper> inconsistentOffers = consistencyValidationResult.getInconsistentOffers();
                    for (OfferWrapper offer : inconsistentOffers) {
                        LoginInfo login = offer.getDescriptor().ref.owner();
                        Application.login().admin.invalidateLogin(login);
                        for (InterfaceWrapper interfaceInfo : interfaces) {
                            Application.login().admin.revokeAuthorization(login.entity, interfaceInfo.getName());
                        }
                        this.setProgressStatus(step + step * i / inconsistentOffers.size());
                        ++i;
                    }
                }
                i = 0;
                Set<AuthorizationWrapper> inconsistentAuthorizations = consistencyValidationResult.getInconsistentAuthorizations();
                for (AuthorizationWrapper authorization : inconsistentAuthorizations) {
                    try {
                        Application.login().admin.revokeAuthorization(authorization.getEntityId(), authorization.getInterface());
                    }
                    catch (NullPointerException login) {
                        // empty catch block
                    }
                    this.setProgressStatus(step * 2 + step * i / inconsistentAuthorizations.size());
                    ++i;
                }
                i = 0;
                for (InterfaceWrapper interfaceInfo : interfaces) {
                    String interfaceName = interfaceInfo.getName();
                    Application.login().admin.removeInterface(interfaceName);
                    this.setProgressStatus(step * 3 + step * i / interfaces.size());
                    ++i;
                }
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus() && delegateAfterTaskUI != null) {
                    delegateAfterTaskUI.run();
                }
            }
        };
    }
}

