/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa.util;

import java.util.Arrays;
import java.util.Random;

public final class IdUtil {
    private static final Random rnd = new Random(9999L);

    public static byte[] concat(byte[] first, byte[] second) {
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static byte[] createId() {
        byte[] time = IdUtil.toId(System.nanoTime());
        byte[] random = IdUtil.toId(rnd.nextLong());
        return IdUtil.concat(time, random);
    }

    public static boolean equals(byte[] first, byte[] second) {
        return Arrays.equals(first, second);
    }

    public static boolean equals(byte[] first, byte[] second, int len) {
        if (first == second) {
            return true;
        }
        if (first.length < len || second.length < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (first[i] == second[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] extract(byte[] id, int offset, int len) {
        byte[] result = new byte[len];
        System.arraycopy(id, offset, result, 0, len);
        return result;
    }

    public static byte[] toId(long l) {
        String str = Long.toOctalString(l);
        if (str.length() % 2 != 0) {
            str = "0" + str;
        }
        byte[] result = new byte[str.length() / 2];
        StringBuffer number = new StringBuffer("xx");
        for (int i = 0; i < result.length; ++i) {
            number.setCharAt(0, str.charAt(i * 2));
            number.setCharAt(1, str.charAt(i * 2 + 1));
            result[i] = Integer.valueOf(number.toString()).byteValue();
            if (result[i] == 47) {
                result[i] = 48;
                continue;
            }
            if (result[i] != 38) continue;
            result[i] = 19;
        }
        return result;
    }
}

