/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.model;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.BadLocationException;
import org.japura.gui.model.AbstractNumberDocument;

public class BigDecimalDocument
extends AbstractNumberDocument<BigDecimal, BigDecimal> {
    private static final long serialVersionUID = 2L;

    public BigDecimalDocument() {
        this((Locale)null);
    }

    public BigDecimalDocument(Locale locale) {
        super(locale, true);
    }

    public BigDecimal getValue() {
        try {
            BigDecimal number;
            String text = this.getText();
            if (text.matches(this.getValidateRegex()) && (number = this.parse(text)) != null) {
                BigDecimal value = new BigDecimal(((Object)number).toString());
                if (this.getMinValue() != null && value.compareTo(this.getMinValue()) < 1) {
                    return null;
                }
                if (this.getMaxValue() != null && value.compareTo(this.getMaxValue()) > 1) {
                    return null;
                }
                return value;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setValue(BigDecimal value) {
        String text = this.format(value);
        try {
            this.remove(0, this.getLength());
            this.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public BigDecimal getMaxValue() {
        return (BigDecimal)this.maxValue;
    }

    public void setMaxValue(BigDecimal maxValue) {
        this.maxValue = maxValue;
    }

    public BigDecimal getMinValue() {
        return (BigDecimal)this.minValue;
    }

    public void setMinValue(BigDecimal minValue) {
        this.minValue = minValue;
    }

    protected DecimalFormat getFormatter() {
        NumberFormat nf = NumberFormat.getInstance(this.getLocale());
        nf.setMaximumFractionDigits(Integer.MAX_VALUE);
        nf.setGroupingUsed(false);
        DecimalFormat df = (DecimalFormat)nf;
        df.setParseBigDecimal(true);
        return df;
    }

    @Override
    protected BigDecimal parse(String text) {
        DecimalFormat n = this.getFormatter();
        try {
            return (BigDecimal)n.parseObject(text);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    protected String format(BigDecimal value) {
        DecimalFormat n = this.getFormatter();
        return n.format(value);
    }

    @Override
    protected boolean isAcceptableValue(BigDecimal number) {
        if (this.getMinValue() != null && number.compareTo(this.getMinValue()) < 1) {
            return false;
        }
        return this.getMaxValue() == null || number.compareTo(this.getMaxValue()) <= 1;
    }

    public final String getSeparator() {
        return this.separator;
    }

    public final void completeWithZero() {
        if (this.separator == null) {
            return;
        }
        try {
            String text = this.getText(0, this.getLength());
            if (text.startsWith(this.separator)) {
                text = "0" + text;
            }
            if (text.startsWith("-" + this.separator)) {
                text = "-0" + text.substring(1);
            }
            if (text.endsWith(this.separator)) {
                text = text + "0";
            }
            this.replace(0, this.getLength(), text, null);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }
}

