/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.util;

import java.awt.Component;
import java.awt.Window;
import javax.swing.SwingUtilities;

public final class GUIUtils {
    public static Window getWindowAncestor(Component component) {
        if (component != null) {
            if (component instanceof Window) {
                return (Window)component;
            }
            Window window = SwingUtilities.getWindowAncestor(component);
            if (window != null) {
                return window;
            }
        }
        return null;
    }

    public static void requestWindowFocus(Component component) {
        Window window;
        if (component != null && (window = GUIUtils.getWindowAncestor(component)) != null) {
            window.requestFocus();
        }
    }

    public static boolean isWindowFocused(Component component) {
        Window window;
        if (component != null && (window = GUIUtils.getWindowAncestor(component)) != null) {
            return window.isFocused();
        }
        return false;
    }
}

