/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;

abstract class BusResource {
    protected Throwable lastError = null;
    protected boolean loggedOut = false;
    protected boolean cancelled = false;
    protected final Object lock = new Object();

    BusResource() {
    }

    public abstract void remove();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(Throwable error) {
        Object object = this.lock;
        synchronized (object) {
            this.lastError = error;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loggedOut() {
        Object object = this.lock;
        synchronized (object) {
            this.loggedOut = true;
            this.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkLoggedOut() {
        Object object = this.lock;
        synchronized (object) {
            if (this.loggedOut) {
                throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    protected void logInterruptError(Logger logger, Exception e) {
        logger.log(Level.SEVERE, "Interrup\u00e7\u00e3o recebida ao aguardar por uma oferta remota.", e);
    }
}

