/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.openbus.OfferRegistryObserver;
import tecgraf.openbus.core.OfferRegistryImpl;
import tecgraf.openbus.core.RemoteOfferImpl;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistryObserverPOA;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOfferDesc;

class OfferRegistryObserverImpl
extends OfferRegistryObserverPOA {
    public final OfferRegistryObserver observer;
    private final OfferRegistryImpl registry;
    private static final Logger logger = Logger.getLogger(OfferRegistryObserverImpl.class.getName());

    protected OfferRegistryObserverImpl(OfferRegistryObserver observer, OfferRegistryImpl registry) {
        this.observer = observer;
        this.registry = registry;
    }

    @Override
    public void offerRegistered(ServiceOfferDesc offer) {
        Thread t = new Thread(() -> {
            RemoteOfferImpl remote = new RemoteOfferImpl(this.registry, offer);
            String login = remote.owner().id;
            String entity = remote.owner().entity;
            try {
                this.observer.offerRegistered(remote);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erro ao avisar um observador da aplica\u00e7\u00e3o de que uma oferta do login " + login + " da entidade " + entity + " foi registrada.", e);
            }
        });
        t.start();
    }
}

