/*
 * Decompiled with CFR 0.152.
 */
package busexplorer;

import busexplorer.utils.BusAddress;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OnReloginCallback;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.admin.BusAdminFacade;
import tecgraf.openbus.admin.BusAdminImpl;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.UnauthorizedOperation;
import tecgraf.openbus.core.v2_1.services.access_control.AccessDenied;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_1.services.access_control.TooManyAttempts;
import tecgraf.openbus.core.v2_1.services.access_control.UnknownDomain;
import tecgraf.openbus.core.v2_1.services.access_control.WrongEncoding;
import tecgraf.openbus.exception.AlreadyLoggedIn;
import tecgraf.openbus.extension.BusExtensionFacade;
import tecgraf.openbus.extension.BusExtensionImpl;

public class BusExplorerLogin {
    public final LoginInfo info;
    public final BusAddress address;
    public final String domain;
    public BusAdminFacade admin;
    public BusExtensionFacade extension;
    private static final short MAX_RETRIES = 3;
    private final OpenBusContext context;
    private boolean adminRights = false;
    private Connection conn;
    private OnReloginCallback onReloginCallback;

    public BusExplorerLogin(BusAddress address, String entity, String domain) throws InvalidName {
        address.checkBusVersion();
        address.checkBusReference();
        this.info = new LoginInfo();
        this.info.entity = entity;
        this.address = address;
        this.domain = domain;
        this.context = (OpenBusContext)ORBInitializer.initORB().resolve_initial_references("OpenBusContext");
    }

    public void onRelogin(OnReloginCallback callback) {
        this.onReloginCallback = callback;
    }

    public void doLogin(String password) throws WrongEncoding, AlreadyLoggedIn, ServiceFailure, UnknownDomain, TooManyAttempts, AccessDenied {
        Object reference = this.getORB().string_to_object(this.address.toIOR());
        this.conn = this.context.connectByReference(reference);
        this.context.defaultConnection(this.conn);
        boolean done = false;
        Throwable lastFailure = null;
        for (int i = 0; i < 3; i = (int)((short)(i + 1))) {
            try {
                this.conn.loginByPassword(this.info.entity, password.getBytes(), this.domain);
                this.conn.onReloginCallback((connection, oldLogin) -> {
                    this.info.id = connection.login().id;
                    try {
                        this.checkAdminRights();
                    }
                    catch (ServiceFailure serviceFailure) {
                        // empty catch block
                    }
                    if (this.onReloginCallback != null) {
                        this.onReloginCallback.onRelogin(connection, oldLogin);
                    }
                });
                this.info.id = this.conn.login().id;
                this.admin = new BusAdminImpl(reference);
                this.extension = new BusExtensionImpl(this.conn.offerRegistry());
                this.checkAdminRights();
                done = true;
                break;
            }
            catch (COMM_FAILURE | TRANSIENT e) {
                lastFailure = e;
            }
            catch (NO_PERMISSION e) {
                if (e.minor != 1112888319) {
                    throw e;
                }
                lastFailure = e;
            }
            catch (Exception e) {
                this.logout();
                throw e;
            }
            try {
                Thread.sleep(250L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!done) {
            throw new IllegalArgumentException(this.address.toIOR(), lastFailure);
        }
    }

    public boolean hasAdminRights() {
        return this.adminRights;
    }

    public void logout() {
        try {
            if (this.conn != null) {
                ORB orb = this.conn.ORB();
                this.conn.logout();
                orb.shutdown(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkAdminRights() throws ServiceFailure {
        try {
            this.admin.getLogins();
            this.adminRights = true;
        }
        catch (UnauthorizedOperation e) {
            this.adminRights = false;
        }
    }

    public OpenBusContext getOpenBusContext() {
        return this.context;
    }

    public ORB getORB() {
        return this.getOpenBusContext().ORB();
    }
}

