/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.exception;

import busexplorer.exception.BusExplorerHandlingException;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.exception.handling.ExceptionType;
import busexplorer.utils.Language;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.TRANSIENT;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.access_control.TooManyAttempts;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceProperty;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.AuthorizationInUse;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.InterfaceInUse;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntityDesc;

public class BusExplorerExceptionHandler
extends ExceptionHandler<BusExplorerHandlingException> {
    @Override
    protected void handleException(BusExplorerHandlingException exception) {
        Exception theException = exception.getException();
        ExceptionType type = (ExceptionType)((Object)exception.getType());
        ExceptionContext context = exception.getContext();
        block0 : switch (type) {
            case AccessDenied: {
                switch (context) {
                    case LoginByPassword: {
                        exception.setErrorMessage(Language.get(this.getClass(), "access.denied.password"));
                        break block0;
                    }
                    case LoginByPrivateKey: {
                        exception.setErrorMessage(Language.get(this.getClass(), "access.denied.key"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Language.get(this.getClass(), "access.denied"));
                break;
            }
            case TooManyAttempts: {
                TooManyAttempts tooMany = (TooManyAttempts)theException;
                switch (tooMany.domain.value()) {
                    case 0: {
                        exception.setErrorMessage(Language.get(this.getClass(), "too.many.attempts.address", tooMany.penaltyTime));
                        break;
                    }
                    case 1: {
                        exception.setErrorMessage(Language.get(this.getClass(), "too.many.attempts.entity", tooMany.penaltyTime));
                        break;
                    }
                    case 2: {
                        exception.setErrorMessage(Language.get(this.getClass(), "too.many.attempts.validator", tooMany.penaltyTime));
                    }
                }
                break;
            }
            case UnknownDomain: {
                exception.setErrorMessage(Language.get(this.getClass(), "unknown.domain"));
                break;
            }
            case ServiceFailure: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Language.get(this.getClass(), "service.failure.core", ((ServiceFailure)((Object)theException)).message));
                        break block0;
                    }
                }
                exception.setErrorMessage(Language.get(this.getClass(), "service.failure", ((ServiceFailure)((Object)theException)).message));
                break;
            }
            case UnauthorizedOperation: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Language.get(this.getClass(), "unauthorized.operation.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Language.get(this.getClass(), "unauthorized.operation"));
                break;
            }
            case EntityAlreadyRegistered: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Language.get(this.getClass(), "entity.already.registered.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Language.get(this.getClass(), "entity.already.registered"));
                break;
            }
            case EntityCategoryAlreadyExists: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Language.get(this.getClass(), "category.already.exists.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Language.get(this.getClass(), "category.already.exists"));
                break;
            }
            case InvalidCertificate: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Language.get(this.getClass(), "invalid.certificate.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Language.get(this.getClass(), "invalid.certificate"));
                break;
            }
            case InterfaceInUse: {
                StringBuilder builder = new StringBuilder();
                RegisteredEntityDesc[] entities = ((InterfaceInUse)theException).entities;
                for (int i = 0; i < entities.length; ++i) {
                    builder.append(" - ");
                    builder.append(entities[i].id);
                    builder.append("\n");
                }
                exception.setErrorMessage(Language.get(this.getClass(), "interface.inuse", builder.toString()));
                break;
            }
            case InvalidInterface: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Language.get(this.getClass(), "invalid.interface.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Language.get(this.getClass(), "invalid.interface"));
                break;
            }
            case AuthorizationInUse: {
                StringBuilder builder = new StringBuilder();
                ServiceOfferDesc[] offers = ((AuthorizationInUse)theException).offers;
                block72: for (int i = 0; i < offers.length; ++i) {
                    for (ServiceProperty prop : offers[i].properties) {
                        if (!prop.name.equals("openbus.offer.id")) continue;
                        builder.append(" - ");
                        builder.append(prop.value);
                        builder.append("\n");
                        continue block72;
                    }
                }
                exception.setErrorMessage(Language.get(this.getClass(), "authorization.inuse", builder.toString()));
                break;
            }
            case OBJECT_NOT_EXIST: {
                switch (context) {
                    case LoginByPassword: 
                    case LoginByPrivateKey: 
                    case BusCore: {
                        exception.setErrorMessage(Language.get(this.getClass(), "not.exist.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Language.get(this.getClass(), "not.exist"));
                break;
            }
            case TRANSIENT: {
                switch (context) {
                    case LoginByPassword: 
                    case LoginByPrivateKey: 
                    case BusCore: {
                        exception.setErrorMessage(Language.get(this.getClass(), "transient.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Language.get(this.getClass(), "transient"));
                break;
            }
            case COMM_FAILURE: {
                switch (context) {
                    case LoginByPassword: 
                    case LoginByPrivateKey: 
                    case BusCore: {
                        exception.setErrorMessage(Language.get(this.getClass(), "comm.failure.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Language.get(this.getClass(), "comm.failure"));
                break;
            }
            case NO_PERMISSION: {
                NO_PERMISSION noPermission = (NO_PERMISSION)((Object)theException);
                switch (context) {
                    case Service: {
                        switch (noPermission.minor) {
                            case 1112888319: {
                                exception.setErrorMessage(Language.get(this.getClass(), "no.permission.no.login"));
                                break;
                            }
                            case 1112888068: {
                                exception.setErrorMessage(Language.get(this.getClass(), "no.permission.unknown.bus"));
                                break;
                            }
                            case 1112888067: {
                                exception.setErrorMessage(Language.get(this.getClass(), "no.permission.unverified.login"));
                                break;
                            }
                            case 1112888318: {
                                exception.setErrorMessage(Language.get(this.getClass(), "no.permission.invalid.remote"));
                            }
                        }
                        break block0;
                    }
                }
                if (noPermission.minor == 1112888319) {
                    exception.setErrorMessage(Language.get(this.getClass(), "no.permission.no.login"));
                    break;
                }
                exception.setErrorMessage(Language.get(this.getClass(), "no.permission.unexpected", noPermission.minor));
                break;
            }
            case InvalidName: {
                exception.setErrorMessage(Language.get(this.getClass(), "unspecified", theException.getClass().getName(), theException.getMessage()));
                break;
            }
            case IncompatibleBus: {
                switch (context) {
                    case LoginByPassword: 
                    case LoginByPrivateKey: {
                        exception.setErrorMessage(Language.get(this.getClass(), "incompatible.bus.login", theException.getMessage()));
                        break block0;
                    }
                }
                exception.setErrorMessage(Language.get(this.getClass(), "incompatible.bus", theException.getMessage()));
                break;
            }
            case IllegalArgumentException: {
                switch (context) {
                    case LoginByPassword: 
                    case LoginByPrivateKey: {
                        Throwable cause = theException.getCause();
                        if (cause != null && (cause instanceof COMM_FAILURE || cause instanceof TRANSIENT || cause instanceof NO_PERMISSION)) {
                            StringBuilder sb = new StringBuilder();
                            sb.append(Language.get(this.getClass(), "illegal.address", theException.getMessage()));
                            sb.append("\n\n");
                            sb.append(cause.getMessage());
                            exception.setErrorMessage(sb.toString());
                            break block0;
                        }
                        exception.setErrorMessage(Language.get(this.getClass(), "illegal.wrong.address", theException.getMessage()));
                        break block0;
                    }
                }
                exception.setErrorMessage(Language.get(this.getClass(), "illegal.argument", theException.getMessage()));
                break;
            }
            default: {
                if (theException != null) {
                    exception.setErrorMessage(Language.get(this.getClass(), "unspecified", theException.getClass().getName(), theException.getMessage()));
                    break;
                }
                exception.setErrorMessage(Language.get(this.getClass(), "javaerror"));
            }
        }
    }

    @Override
    protected BusExplorerHandlingException getHandlingException(Exception exception, ExceptionContext context) {
        return new BusExplorerHandlingException(exception, context);
    }
}

