/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel;

import busexplorer.ApplicationIcons;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.BusQuery;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.function.Function;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntityDesc;

public class BusQueryValidateAction<T, String>
extends OpenBusAction {
    private final Function<T, String> extract;
    private final T uicomponent;

    public BusQueryValidateAction(Window parent, T component, Function<T, String> extract) {
        super(parent);
        this.uicomponent = component;
        this.extract = extract;
        this.putValue("ShortDescription", this.getString("tooltip"));
        this.putValue("SmallIcon", ApplicationIcons.ICON_GAUGE_16);
    }

    boolean isValidExpression() throws ScriptException {
        String expression = this.extract.apply(this.uicomponent);
        return new BusQuery((String)expression).isValid();
    }

    ArrayList<RegisteredEntityDesc> evaluateExpression() throws ScriptException, ServiceFailure {
        String expression = this.extract.apply(this.uicomponent);
        return new BusQuery((String)expression).filterEntities();
    }

    @Override
    public boolean abilityConditions() {
        try {
            return this.isValidExpression();
        }
        catch (ScriptException ex) {
            return false;
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.OTHER;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        BusExplorerTask<ArrayList<RegisteredEntityDesc>> task = new BusExplorerTask<ArrayList<RegisteredEntityDesc>>(ExceptionContext.BusCore){
            boolean assignmentTest;
            {
                this.assignmentTest = false;
            }

            @Override
            protected void doPerformTask() throws Exception {
                if (BusQueryValidateAction.this.isValidExpression()) {
                    this.setResult(BusQueryValidateAction.this.evaluateExpression());
                } else {
                    this.assignmentTest = true;
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    if (!this.assignmentTest && ((ArrayList)this.getResult()).size() > 0) {
                        JOptionPane.showMessageDialog(this.parentWindow, BusQueryValidateAction.this.getString("result.success"), BusQueryValidateAction.this.getString("waiting.title"), 1);
                    } else if (this.assignmentTest) {
                        JOptionPane.showMessageDialog(this.parentWindow, BusQueryValidateAction.this.getString("prohibited.assignment"), BusQueryValidateAction.this.getString("waiting.title"), 0);
                    } else {
                        JOptionPane.showMessageDialog(this.parentWindow, BusQueryValidateAction.this.getString("result.none"), BusQueryValidateAction.this.getString("waiting.title"), 0);
                    }
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

