/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.categories;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.categories.CategoryWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.EntityCategory;

public class CategoryInputDialog
extends BusExplorerAbstractInputDialog {
    private JLabel categoryIDLabel;
    private JTextField categoryIDField;
    private JLabel categoryNameLabel;
    private JTextArea categoryNameField;
    private TablePanelComponent<CategoryWrapper> panel;
    private CategoryWrapper editingCategory = null;

    public CategoryInputDialog(Window parentWindow, TablePanelComponent<CategoryWrapper> panel) {
        super(parentWindow);
        this.panel = panel;
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){
            EntityCategory category;

            @Override
            protected void doPerformTask() throws Exception {
                if (CategoryInputDialog.this.editingCategory == null) {
                    this.category = Application.login().admin.createCategory(CategoryInputDialog.this.getCategoryID(), CategoryInputDialog.this.getCategoryName());
                } else {
                    this.category = ((CategoryInputDialog)CategoryInputDialog.this).editingCategory.getDescriptor().ref;
                    this.category.setName(CategoryInputDialog.this.getCategoryName());
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    CategoryInputDialog.this.panel.refresh(null);
                    CategoryInputDialog.this.panel.selectElement(new CategoryWrapper(this.category.describe()), true);
                }
            }
        };
        task.execute(this, Language.get(this.getClass(), "waiting.title"), Language.get(this.getClass(), "waiting.msg"));
        return task.getStatus();
    }

    @Override
    public JPanel buildFields() {
        this.setMinimumSize(new Dimension(300, 300));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill, flowy"));
        this.categoryIDLabel = new JLabel(Language.get(this.getClass(), "categoryID.label"));
        panel.add((Component)this.categoryIDLabel, "grow");
        this.categoryIDField = new JTextField(30);
        this.categoryIDField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (CategoryInputDialog.this.categoryIDField.getText().trim().isEmpty()) {
                    CategoryInputDialog.this.setErrorMessage(Language.get(CategoryInputDialog.class, "error.validation.name"));
                } else {
                    CategoryInputDialog.this.clearErrorMessage();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        panel.add((Component)this.categoryIDField, "grow");
        this.categoryNameLabel = new JLabel(Language.get(this.getClass(), "categoryName.label"));
        panel.add((Component)this.categoryNameLabel, "grow");
        this.categoryNameField = new JTextArea(5, 20);
        this.categoryNameField.setLineWrap(true);
        panel.add((Component)new JScrollPane(this.categoryNameField), "grow, push");
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        if (this.categoryIDField.getText().trim().isEmpty()) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.name"));
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    public void setEditionMode(CategoryWrapper info) {
        this.editingCategory = info;
        this.categoryIDField.setText(info.getId());
        this.categoryIDField.setEnabled(false);
        this.categoryNameField.setText(info.getName());
    }

    private String getCategoryID() {
        return this.categoryIDField.getText();
    }

    private String getCategoryName() {
        return this.categoryNameField.getText();
    }
}

