/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.integrations;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.consumers.ConsumerWrapper;
import busexplorer.panel.contracts.ContractWrapper;
import busexplorer.panel.integrations.IntegrationInputDialog;
import busexplorer.panel.integrations.IntegrationWrapper;
import busexplorer.panel.providers.ProviderWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;

public class IntegrationEditAction
extends OpenBusAction<IntegrationWrapper> {
    public IntegrationEditAction(JFrame parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.EDIT;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){
            List<ConsumerWrapper> consumers;
            List<ProviderWrapper> providers;
            List<ContractWrapper> contracts;

            @Override
            protected void doPerformTask() throws Exception {
                this.consumers = ConsumerWrapper.convertToInfo(Application.login().extension.getConsumers());
                this.providers = ProviderWrapper.convertToInfo(Application.login().extension.getProviders());
                this.contracts = ContractWrapper.convertToInfo(Application.login().extension.getContracts());
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    IntegrationInputDialog dialog = new IntegrationInputDialog(IntegrationEditAction.this.parentWindow, IntegrationEditAction.this.getTablePanelComponent(), this.consumers, this.providers, this.contracts);
                    dialog.showDialog();
                    dialog.setEditionMode((IntegrationWrapper)IntegrationEditAction.this.getTablePanelComponent().getSelectedElement());
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

