/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.desktop.dialog;

import busexplorer.ApplicationIcons;
import busexplorer.desktop.dialog.CloseAction;
import busexplorer.desktop.dialog.DetailThrowableAction;
import busexplorer.desktop.dialog.JMultilineLabel;
import busexplorer.desktop.dialog.ThrowableTreeNode;
import busexplorer.utils.Language;
import busexplorer.utils.SwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public abstract class ExceptionDialog
extends JDialog {
    protected final Throwable _throwable;

    protected ExceptionDialog(Window owner, String title, Throwable throwable) {
        super(owner, title);
        this._throwable = throwable;
        this.setWindowClosingMethod();
    }

    private void setWindowClosingMethod() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ExceptionDialog.this.dispose();
            }
        });
    }

    public static JDialog createDialog(Window window, String title, Throwable throwable, String message) {
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessageType(0);
        optionPane.setMessage(ExceptionDialog.createComponents(message));
        JDialog dialog = optionPane.createDialog(window, title);
        Vector<JButton> buttons = new Vector<JButton>();
        if (throwable != null) {
            buttons.add(new JButton(new DetailThrowableAction(dialog, throwable)));
        }
        if (message != null && !message.isEmpty()) {
            JButton copy = new JButton(ApplicationIcons.ICON_COPY_16);
            copy.setToolTipText(Language.get(ExceptionDialog.class, "copy.tooltip"));
            copy.setText(Language.get(ExceptionDialog.class, "copy.name"));
            copy.setMnemonic(Language.get(ExceptionDialog.class, "copy.mnemonic").charAt(0));
            copy.addActionListener(al -> {
                StringSelection stringSelection = new StringSelection(message);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
            });
            buttons.add(copy);
        }
        buttons.add(new JButton(new CloseAction(dialog)));
        Object[] options = buttons.toArray(new JButton[0]);
        SwingUtilities.equalizeComponentSize((JComponent[])options);
        optionPane.setOptions(options);
        dialog.pack();
        dialog.getRootPane().setDefaultButton((JButton)options[0]);
        return dialog;
    }

    public static ExceptionDialog createDialog(Window window, String title, Throwable throwable) {
        return new DetailedExceptionDialog(window, title, throwable);
    }

    private static JPanel createComponents(String message) {
        JPanel mainPanel = new JPanel(new MigLayout("fill, flowy"));
        if (message == null || message.isEmpty()) {
            mainPanel.add(new JLabel(Language.get(ExceptionDialog.class, "executionError")));
            mainPanel.add(new JLabel(Language.get(ExceptionDialog.class, "contactError")));
        } else if (message.startsWith("<html>")) {
            JLabel label = new JLabel(message);
            mainPanel.add((Component)label, "grow");
        } else {
            JMultilineLabel label = new JMultilineLabel();
            label.setMaxWidth(400);
            label.setJustified(false);
            label.setText(message);
            JScrollPane js = new JScrollPane(label);
            js.setViewportBorder(null);
            js.setBorder(null);
            mainPanel.add((Component)js, "grow");
        }
        return mainPanel;
    }

    public void center() {
        this.center(this.getOwner());
    }

    public void center(Window window) {
        int minY;
        JFrame jframe;
        int windowState;
        if (window == null) {
            GUIUtils.centerOnScreen(this);
            return;
        }
        if (window instanceof JFrame && ((windowState = (jframe = (JFrame)window).getExtendedState()) & 6) != 0) {
            GUIUtils.centerOnScreen(this);
            return;
        }
        Dimension currentSize = this.getSize();
        Dimension windowSize = window.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int minX = window.getX() + (windowSize.width - currentSize.width) / 2;
        if (minX + currentSize.width > screenSize.width) {
            minX = screenSize.width - currentSize.width;
        }
        if (minX < 0) {
            minX = 0;
        }
        if ((minY = window.getY() + (windowSize.height - currentSize.height) / 2) + currentSize.height > screenSize.height) {
            minY = screenSize.height - currentSize.height;
        }
        if (minY < 0) {
            minY = 0;
        }
        this.setLocation(minX, minY);
    }

    private static final class DetailedExceptionDialog
    extends ExceptionDialog {
        private static final int _MESSAGE_COLUMNS = 80;
        private static final int _MESSAGE_ROWS = 4;
        private static final int _STACK_TRACE_COLUMNS = 80;
        private static final int _STACK_TRACE_ROWS = 14;
        private static final int _TROUBLE_TREE_WIDTH = 800;
        private static final int _TROUBLE_TREE_HEIGHT = 100;
        private JTextArea _messageTextArea;
        private JTextArea _stackTraceTextArea;
        private JTree _throwableTree;

        public DetailedExceptionDialog(Window owner, String title, Throwable throwable) {
            super(owner, title, throwable);
            this.setModal(true);
            this.createComponents();
        }

        private void createComponents() {
            this.setMinimumSize(new Dimension(750, 550));
            Color inactiveColor = UIManager.getDefaults().getColor("TextField.inactiveBackground");
            JLabel troubleTreeLabel = new JLabel(Language.get(this.getClass(), "exceptionTree"));
            this._throwableTree = new JTree(new ThrowableTreeNode(this._throwable));
            this._throwableTree.addTreeSelectionListener(e -> this.updateFields());
            this._throwableTree.getSelectionModel().setSelectionMode(1);
            JScrollPane scrollTroubleTree = new JScrollPane(this._throwableTree);
            scrollTroubleTree.setPreferredSize(new Dimension(800, 100));
            JLabel messageLabel = new JLabel(Language.get(this.getClass(), "exceptionMessage"));
            this._messageTextArea = new JTextArea(this._throwable.getLocalizedMessage());
            this._messageTextArea.setColumns(80);
            this._messageTextArea.setRows(4);
            this._messageTextArea.setEditable(false);
            this._messageTextArea.setBackground(inactiveColor);
            JLabel stackTraceLabel = new JLabel(Language.get(this.getClass(), "stackTrace"));
            this._stackTraceTextArea = new JTextArea(this.getStackTraceText(this._throwable.getStackTrace()));
            this._stackTraceTextArea.setColumns(80);
            this._stackTraceTextArea.setRows(14);
            this._stackTraceTextArea.setEditable(false);
            this._stackTraceTextArea.setBackground(inactiveColor);
            JPanel buttonsPanel = this.createButtonPanel();
            this.setLayout(new GridBagLayout());
            JScrollPane msgScrollPane = new JScrollPane(this._messageTextArea);
            JScrollPane stackTraceScroll = new JScrollPane(this._stackTraceTextArea);
            Insets li = new Insets(5, 6, 0, 10);
            Insets fi = new Insets(3, 10, 5, 10);
            int y = 0;
            this.add((Component)troubleTreeLabel, new GBC(0, y++).west().insets(li));
            this.add((Component)scrollTroubleTree, new GBC(0, y++).both().insets(fi));
            this.add((Component)messageLabel, new GBC(0, y++).west().insets(li));
            this.add((Component)msgScrollPane, new GBC(0, y++).both().insets(fi));
            this.add((Component)stackTraceLabel, new GBC(0, y++).west().insets(li));
            this.add((Component)stackTraceScroll, new GBC(0, y++).both().insets(fi));
            this.add((Component)buttonsPanel, new GBC(0, y++).center().insets(7));
            this.pack();
            this.center();
        }

        private JPanel createButtonPanel() {
            JPanel panel = new JPanel();
            JButton closeButton = new JButton(new CloseAction(this));
            SwingUtilities.equalizeComponentSize(closeButton);
            panel.add(closeButton);
            return panel;
        }

        private void updateFields() {
            ThrowableTreeNode node = (ThrowableTreeNode)this._throwableTree.getSelectionPath().getLastPathComponent();
            if (node == null) {
                node = (ThrowableTreeNode)this._throwableTree.getModel().getRoot();
            }
            this._messageTextArea.setText(node.getThrowable().getLocalizedMessage());
            this._stackTraceTextArea.setText(this.getStackTraceText(node.getThrowable().getStackTrace()));
        }

        private String getStackTraceText(StackTraceElement[] stackTrace) {
            String text = "";
            for (StackTraceElement aStackTrace : stackTrace) {
                text = text + aStackTrace + "\n";
            }
            return text;
        }
    }
}

