/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.certificates;

import busexplorer.Application;
import busexplorer.desktop.dialog.InputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.certificates.CertificateWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;

public class CertificateDeleteAction
extends OpenBusAction<CertificateWrapper> {
    public CertificateDeleteAction(JFrame parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REMOVE;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (InputDialog.showConfirmDialog(this.parentWindow, this.getString("confirm.msg"), this.getString("confirm.title")) != 0) {
            return;
        }
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                List certificates = CertificateDeleteAction.this.getTablePanelComponent().getSelectedElements();
                for (CertificateWrapper certificate : certificates) {
                    String entityId = certificate.getEntity();
                    Application.login().admin.removeCertificate(entityId);
                }
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    CertificateDeleteAction.this.getTablePanelComponent().removeSelectedElements();
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

