/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.integrations;

import busexplorer.Application;
import busexplorer.desktop.dialog.InputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.integrations.IntegrationWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;

public class IntegrationDeleteAction
extends OpenBusAction<IntegrationWrapper> {
    public IntegrationDeleteAction(JFrame parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REMOVE;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (InputDialog.showConfirmDialog(this.parentWindow, this.getString("confirm.msg"), this.getString("confirm.title")) != 0) {
            return;
        }
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.Service){

            @Override
            protected void doPerformTask() throws Exception {
                List integrations = IntegrationDeleteAction.this.getTablePanelComponent().getSelectedElements();
                for (IntegrationWrapper integration : integrations) {
                    Application.login().extension.getIntegrationRegistry().remove(integration.remote().id());
                }
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    IntegrationDeleteAction.this.getTablePanelComponent().removeSelectedElements();
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

