/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.awt.Color;
import org.apache.poi.util.Internal;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;

public class XSSFColor
implements org.apache.poi.ss.usermodel.Color {
    private CTColor ctColor;

    public XSSFColor(CTColor color) {
        this.ctColor = color;
    }

    public XSSFColor() {
        this.ctColor = CTColor.Factory.newInstance();
    }

    public XSSFColor(Color clr) {
        this();
        this.ctColor.setRgb(new byte[]{(byte)clr.getRed(), (byte)clr.getGreen(), (byte)clr.getBlue()});
    }

    public XSSFColor(byte[] rgb) {
        this();
        this.ctColor.setRgb(rgb);
    }

    public boolean isAuto() {
        return this.ctColor.getAuto();
    }

    public void setAuto(boolean auto) {
        this.ctColor.setAuto(auto);
    }

    public short getIndexed() {
        return (short)this.ctColor.getIndexed();
    }

    public void setIndexed(int indexed) {
        this.ctColor.setIndexed(indexed);
    }

    public byte[] getRgb() {
        return this.ctColor.getRgb();
    }

    public byte[] getRgbWithTint() {
        byte[] rgb = this.ctColor.getRgb();
        for (int i = 0; i < rgb.length; ++i) {
            rgb[i] = XSSFColor.applyTint(rgb[i] & 0xFF, this.ctColor.getTint());
        }
        return rgb;
    }

    public String getARGBHex() {
        StringBuffer sb = new StringBuffer();
        byte[] rgb = this.getRgb();
        if (rgb == null) {
            return null;
        }
        for (int n : rgb) {
            String cs;
            int i = n;
            if (i < 0) {
                i += 256;
            }
            if ((cs = Integer.toHexString(i)).length() == 1) {
                sb.append('0');
            }
            sb.append(cs);
        }
        return sb.toString().toUpperCase();
    }

    private static byte applyTint(int lum, double tint) {
        if (tint > 0.0) {
            return (byte)((double)lum * (1.0 - tint) + (255.0 - 255.0 * (1.0 - tint)));
        }
        if (tint < 0.0) {
            return (byte)((double)lum * (1.0 + tint));
        }
        return (byte)lum;
    }

    public void setRgb(byte[] rgb) {
        this.ctColor.setRgb(rgb);
    }

    public int getTheme() {
        return (int)this.ctColor.getTheme();
    }

    public void setTheme(int theme) {
        this.ctColor.setTheme(theme);
    }

    public double getTint() {
        return this.ctColor.getTint();
    }

    public void setTint(double tint) {
        this.ctColor.setTint(tint);
    }

    @Internal
    public CTColor getCTColor() {
        return this.ctColor;
    }

    public int hashCode() {
        return this.ctColor.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XSSFColor)) {
            return false;
        }
        XSSFColor cf = (XSSFColor)o;
        return this.ctColor.toString().equals(cf.getCTColor().toString());
    }
}

