/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Collection;
import org.jacorb.orb.ApplicationExceptionHelper;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.RequestOutputStream;
import org.jacorb.orb.portableInterceptor.ClientInterceptorHandler;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.GIOP.ReplyHeader_1_2;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.slf4j.Logger;

public class DefaultClientInterceptorHandler
implements ClientInterceptorHandler {
    private final ClientRequestInfoImpl info;
    private final Logger logger;
    private boolean isLocal = false;

    public DefaultClientInterceptorHandler(DefaultClientInterceptorHandler original, ORB orb, RequestOutputStream ros, Object self, Delegate delegate, ParsedIOR piorOriginal, ClientConnection connection) {
        this.info = orb.hasClientRequestInterceptors() ? new ClientRequestInfoImpl(orb, original != null ? original.info : null, ros, self, delegate, piorOriginal, connection, Delegate.getInvocationContext().peek()) : null;
        this.logger = orb.getConfiguration().getLogger("org.jacorb.orb.client_interceptors");
    }

    public DefaultClientInterceptorHandler(ORB orb, String operation, boolean response_expected, short sync_scope, Object self, Delegate delegate, ParsedIOR piorOriginal) {
        this.info = new ClientRequestInfoImpl(orb, operation, response_expected, sync_scope, self, delegate, piorOriginal, Delegate.getInvocationContext().peek());
        this.isLocal = true;
        this.logger = orb.getConfiguration().getLogger("org.jacorb.orb.client_interceptors");
    }

    @Override
    public void handle_send_request() throws RemarshalException, ForwardRequest {
        if (this.info != null) {
            this.invokeInterceptors(this.info, (short)0);
            if (!this.isLocal) {
                Collection<ServiceContext> ctx = this.info.getRequestServiceContexts();
                for (ServiceContext s : ctx) {
                    this.info.request_os.addServiceContext(s);
                }
            }
        }
    }

    @Override
    public void handle_location_forward(ReplyInputStream reply, Object forward_reference) throws RemarshalException, ForwardRequest {
        if (this.info != null) {
            this.info.setReplyStatus((short)3);
            this.info.setForwardReference(forward_reference);
            if (reply != null) {
                this.info.reply_is = reply;
                this.info.setReplyServiceContexts(reply.rep_hdr.service_context);
            }
            this.invokeInterceptors(this.info, (short)4);
        }
    }

    @Override
    public void handle_receive_reply(ReplyInputStream reply) throws RemarshalException, ForwardRequest {
        if (this.info != null) {
            if (reply != null) {
                ReplyHeader_1_2 header = reply.rep_hdr;
                if (header.reply_status.value() == 0) {
                    this.info.setReplyStatus((short)0);
                    this.info.setReplyServiceContexts(header.service_context);
                    if (this.info.request_os.getRequest() == null) {
                        InterceptorManager manager = this.info.orb.getInterceptorManager();
                        this.info.setCurrent(manager.getCurrent());
                        this.info.reply_is = reply;
                        this.invokeInterceptors(this.info, (short)2);
                    } else {
                        this.info.request_os.getRequest().setInfo(this.info);
                    }
                }
            } else {
                this.info.setReplyStatus((short)0);
                this.invokeInterceptors(this.info, (short)2);
            }
        }
    }

    @Override
    public void handle_receive_other(short reply_status) throws RemarshalException, ForwardRequest {
        if (this.info != null) {
            this.info.setReplyStatus(reply_status);
            this.invokeInterceptors(this.info, (short)4);
        }
    }

    @Override
    public void handle_receive_exception(SystemException exception) throws RemarshalException, ForwardRequest {
        this.handle_receive_exception(exception, null);
    }

    @Override
    public void handle_receive_exception(SystemException exception, ReplyInputStream reply) throws RemarshalException, ForwardRequest {
        if (this.info != null) {
            block4: {
                SystemExceptionHelper.insert(this.info.received_exception, exception);
                try {
                    this.info.received_exception_id = SystemExceptionHelper.type(exception).id();
                }
                catch (BadKind bk) {
                    if (!this.logger.isDebugEnabled()) break block4;
                    this.logger.debug("BadKind: " + bk.getMessage());
                }
            }
            this.info.setReplyStatus((short)1);
            if (reply != null) {
                this.info.setReplyServiceContexts(reply.rep_hdr.service_context);
                this.info.reply_is = reply;
            }
            this.invokeInterceptors(this.info, (short)3);
        }
    }

    @Override
    public void handle_receive_exception(ApplicationException exception, ReplyInputStream reply) throws RemarshalException, ForwardRequest {
        if (this.info != null) {
            this.info.received_exception_id = exception.getId();
            try {
                ApplicationExceptionHelper.insert(this.info.received_exception, exception);
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(e.getMessage());
                }
                SystemExceptionHelper.insert(this.info.received_exception, new UNKNOWN(e.getMessage()));
            }
            this.info.setReplyStatus((short)2);
            if (reply != null) {
                try {
                    reply.reset();
                }
                catch (Exception e) {
                    this.logger.warn("unexpected exception", e);
                }
                this.info.setReplyServiceContexts(reply.rep_hdr.service_context);
                this.info.reply_is = reply;
            }
            this.invokeInterceptors(this.info, (short)3);
        }
    }

    public ClientRequestInfoImpl getInfo() {
        return this.info;
    }

    private void invokeInterceptors(ClientRequestInfoImpl info, short op) throws RemarshalException, ForwardRequest {
        block4: {
            ClientInterceptorIterator intercept_iter = info.orb.getInterceptorManager().getClientIterator();
            try {
                intercept_iter.iterate(info, op);
            }
            catch (ForwardRequest fwd) {
                info.setForwardReference(fwd.forward);
                if (this.isLocal) {
                    throw fwd;
                }
                info.delegate.forwardToObj(fwd.forward);
                throw new RemarshalException();
            }
            catch (UserException ue) {
                if (!this.logger.isWarnEnabled()) break block4;
                this.logger.warn("UserException: " + ue.toString());
            }
        }
    }
}

