/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import org.japura.gui.CollapsiblePanel;

public class CollapsibleRootPanel
extends JPanel
implements Scrollable {
    private static final long serialVersionUID = 1L;
    public static final Mode FILL = Mode.FILL;
    public static final Mode SCROLL_BAR = Mode.SCROLL_BAR;
    private Mode mode;
    private List<CollapsiblePanel> panels;
    private int maxWidth;
    private int maxHeight;
    private Insets margin;
    private int panelGap = 10;

    public CollapsibleRootPanel() {
        this(Mode.SCROLL_BAR);
    }

    public CollapsibleRootPanel(Mode mode) {
        this.mode = mode;
        this.setMargin(new Insets(10, 10, 10, 10));
        this.setBackground(Color.WHITE);
        this.panels = new ArrayList<CollapsiblePanel>();
        super.setLayout(null);
        if (mode.equals((Object)FILL)) {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    CollapsibleRootPanel.this.adjustEndHeights();
                }
            });
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = null;
        if (this.isPreferredSizeSet()) {
            dim = super.getPreferredSize();
        } else {
            dim = new Dimension();
            for (int i = 0; i < this.panels.size(); ++i) {
                CollapsiblePanel cp = this.panels.get(i);
                if (!cp.isVisible()) continue;
                Dimension cpDim = cp.getPreferredSize();
                dim.width = Math.max(dim.width, cpDim.width);
                dim.height += cpDim.height;
                if (i >= this.panels.size() - 1) continue;
                dim.height += this.panelGap;
            }
            Insets insets = this.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.bottom + insets.top;
            dim.width += this.margin.left + this.margin.right;
            dim.height += this.margin.top + this.margin.bottom;
        }
        if (!(this.getParent() instanceof JViewport)) {
            dim.width += UIManager.getInt("ScrollBar.width");
            this.applyMax(dim);
        }
        return dim;
    }

    private void applyMax(Dimension dim) {
        if (this.getMaxHeight() > 0) {
            dim.height = Math.min(dim.height, this.getMaxHeight());
        }
        if (this.getMaxWidth() > 0) {
            dim.width = Math.min(dim.width, this.getMaxWidth());
        }
    }

    @Override
    public void doLayout() {
        if (this.mode.equals((Object)Mode.FILL)) {
            this.adjustCalculatedHeights();
        }
        int x = this.margin.left;
        int y = this.margin.top;
        for (int i = 0; i < this.panels.size(); ++i) {
            CollapsiblePanel cp = this.panels.get(i);
            if (!cp.isVisible()) continue;
            int height = cp.getCalculatedHeight();
            cp.setBounds(x, y, this.getWidth() - (this.margin.left + this.margin.right), height);
            y += height;
            if (i >= this.panels.size() - 1) continue;
            y += this.panelGap;
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    @Override
    public Component add(Component comp, int index) {
        return null;
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
    }

    @Override
    public void add(Component comp, Object constraints) {
    }

    @Override
    public Component add(Component comp) {
        return null;
    }

    @Override
    public Component add(String name, Component comp) {
        return null;
    }

    public void add(CollapsiblePanel collapsiblePanel, int weight) {
        if (!this.panels.contains(collapsiblePanel)) {
            collapsiblePanel.weightY = Math.max(0, weight);
            this.panels.add(collapsiblePanel);
            super.add(collapsiblePanel);
        }
    }

    public void remove(CollapsiblePanel collapsiblePanel) {
        this.panels.remove(collapsiblePanel);
        super.remove(collapsiblePanel);
    }

    @Override
    public void removeAll() {
        this.panels.clear();
        super.removeAll();
    }

    void adjustEndHeights() {
        double total = 0.0;
        int visiblePanels = 0;
        for (CollapsiblePanel cp : this.panels) {
            if (!cp.isVisible()) continue;
            ++visiblePanels;
            if (!cp.isExpanded() && !cp.isExpanding()) continue;
            total += (double)cp.weightY;
        }
        int height = this.getHeight();
        height -= this.margin.top + this.margin.bottom;
        height -= Math.max(0, visiblePanels - 1) * this.panelGap;
        for (CollapsiblePanel cp : this.panels) {
            if (!cp.isVisible()) continue;
            if (cp.isCollapsed()) {
                if (cp.weightY > 0) {
                    height -= cp.getCalculatedHeight();
                    continue;
                }
                height -= cp.getPreferredSize().height;
                continue;
            }
            if (cp.isCollapsing()) {
                height -= cp.getCalculatedHeight();
                continue;
            }
            if (!cp.isCollapsed() && cp.weightY != 0) continue;
            height -= cp.getPreferredSize().height;
        }
        for (CollapsiblePanel cp : this.panels) {
            if (!cp.isVisible() || !cp.isExpanding()) continue;
            if (cp.weightY > 0) {
                double per = 100.0 * (double)cp.weightY / total;
                double endHeight = (double)height * per / 100.0;
                cp.setEndHeight((int)endHeight);
                continue;
            }
            cp.setEndHeight(cp.getPreferredSize((boolean)false).height);
        }
    }

    private void adjustCalculatedHeights() {
        double total = 0.0;
        int visiblePanels = 0;
        for (CollapsiblePanel cp : this.panels) {
            if (!cp.isVisible()) continue;
            ++visiblePanels;
            if (!cp.isExpanded()) continue;
            total += (double)cp.weightY;
        }
        int height = this.getHeight();
        height -= this.margin.top + this.margin.bottom;
        height -= Math.max(0, visiblePanels - 1) * this.panelGap;
        for (CollapsiblePanel cp : this.panels) {
            if (!cp.isVisible()) continue;
            if (cp.weightY > 0) {
                if (cp.isExpanded()) continue;
                height -= cp.getCalculatedHeight();
                continue;
            }
            if (cp.isCollapsed() || cp.isExpanded()) {
                height -= cp.getPreferredSize().height;
                continue;
            }
            height -= cp.getCalculatedHeight();
        }
        for (CollapsiblePanel cp : this.panels) {
            if (!cp.isVisible() || !cp.isExpanded()) continue;
            if (cp.weightY > 0) {
                double per = 100.0 * (double)cp.weightY / total;
                double endHeight = (double)height * per / 100.0;
                cp.setCalculatedHeight((int)endHeight);
                continue;
            }
            cp.setCalculatedHeight(cp.getPreferredSize((boolean)false).height);
        }
    }

    public void add(CollapsiblePanel collapsiblePanel) {
        this.add(collapsiblePanel, 1);
    }

    public void expandAll() {
        for (CollapsiblePanel cp : this.panels) {
            cp.expand();
        }
    }

    public void collapseAll() {
        for (CollapsiblePanel cp : this.panels) {
            cp.collapse();
        }
    }

    public void setLockAllEnabled(boolean enabled) {
        for (CollapsiblePanel cp : this.panels) {
            cp.setLockEnabled(enabled);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dim = this.getPreferredSize();
        dim.width += UIManager.getInt("ScrollBar.width");
        this.applyMax(dim);
        return dim;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 15;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        JViewport vp;
        return this.getParent() instanceof JViewport && (vp = (JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 15;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = Math.max(maxWidth, 0);
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = Math.max(maxHeight, 0);
    }

    public Mode getMode() {
        return this.mode;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public final void setMargin(Insets margin) {
        if (margin == null) {
            margin = new Insets(0, 0, 0, 0);
        } else {
            margin.bottom = Math.max(margin.bottom, 0);
            margin.left = Math.max(margin.left, 0);
            margin.top = Math.max(margin.top, 0);
            margin.right = Math.max(margin.right, 0);
        }
        this.margin = margin;
    }

    public int getPanelGap() {
        return this.panelGap;
    }

    public void setPanelGap(int panelGap) {
        this.panelGap = Math.max(0, panelGap);
    }

    public List<CollapsiblePanel> getCollapsiblePanels() {
        return Collections.unmodifiableList(this.panels);
    }

    public static enum Mode {
        SCROLL_BAR,
        FILL;

    }
}

