/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.List;

public class WidgetLayout
implements LayoutManager2 {
    private int gap = 5;
    private List<Component> ct = new ArrayList<Component>();
    private List<Component> cb;
    private List<Component> cc = new ArrayList<Component>();
    private List<Component> lt;
    private List<Component> lb;
    private List<Component> lc;
    private List<Component> rt;
    private List<Component> rb;
    private List<Component> rc;

    public WidgetLayout() {
        this.cb = new ArrayList<Component>();
        this.lt = new ArrayList<Component>();
        this.lc = new ArrayList<Component>();
        this.lb = new ArrayList<Component>();
        this.rt = new ArrayList<Component>();
        this.rc = new ArrayList<Component>();
        this.rb = new ArrayList<Component>();
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, null);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.ct.remove(comp);
        this.cc.remove(comp);
        this.cb.remove(comp);
        this.lt.remove(comp);
        this.lc.remove(comp);
        this.lb.remove(comp);
        this.rt.remove(comp);
        this.rc.remove(comp);
        this.rb.remove(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return null;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return null;
    }

    private int center(int parent, int comp) {
        return (parent /= 2) - (comp /= 2);
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension dim;
        int th = 0;
        int y = 0;
        int x = 0;
        y = this.gap;
        for (Component c : this.ct) {
            dim = c.getPreferredSize();
            x = this.center(parent.getWidth(), dim.width);
            c.setBounds(x, y, dim.width, dim.height);
            y += this.gap + dim.height;
        }
        th = 0;
        for (Component c : this.cc) {
            dim = c.getPreferredSize();
            th += dim.height;
        }
        y = this.center(parent.getHeight(), th += this.gap * this.cc.size() - 1);
        for (Component c : this.cc) {
            dim = c.getPreferredSize();
            x = this.center(parent.getWidth(), dim.width);
            c.setBounds(x, y, dim.width, dim.height);
            y += dim.height + this.gap;
        }
        y = parent.getHeight() - this.gap;
        for (Component c : this.cb) {
            dim = c.getPreferredSize();
            y = (int)((double)y - dim.getHeight());
            x = this.center(parent.getWidth(), dim.width);
            c.setBounds(x, y, dim.width, dim.height);
            y -= this.gap;
        }
        y = this.gap;
        x = this.gap;
        for (Component c : this.lt) {
            dim = c.getPreferredSize();
            c.setBounds(x, y, dim.width, dim.height);
            y += this.gap + dim.height;
        }
        x = this.gap;
        th = 0;
        for (Component c : this.lc) {
            dim = c.getPreferredSize();
            th += dim.height;
        }
        y = this.center(parent.getHeight(), th += this.gap * this.lc.size() - 1);
        for (Component c : this.lc) {
            dim = c.getPreferredSize();
            c.setBounds(x, y, dim.width, dim.height);
            y += dim.height + this.gap;
        }
        x = this.gap;
        y = parent.getHeight() - this.gap;
        for (Component c : this.lb) {
            dim = c.getPreferredSize();
            y = (int)((double)y - dim.getHeight());
            c.setBounds(x, y, dim.width, dim.height);
            y -= this.gap;
        }
        y = this.gap;
        for (Component c : this.rt) {
            dim = c.getPreferredSize();
            x = parent.getWidth() - this.gap - dim.width;
            c.setBounds(x, y, dim.width, dim.height);
            y += this.gap + dim.height;
        }
        th = 0;
        for (Component c : this.rc) {
            dim = c.getPreferredSize();
            th += dim.height;
        }
        y = this.center(parent.getHeight(), th += this.gap * this.rc.size() - 1);
        for (Component c : this.rc) {
            dim = c.getPreferredSize();
            x = parent.getWidth() - this.gap - dim.width;
            c.setBounds(x, y, dim.width, dim.height);
            y += dim.height + this.gap;
        }
        y = parent.getHeight() - this.gap;
        for (Component c : this.rb) {
            dim = c.getPreferredSize();
            x = parent.getWidth() - this.gap - dim.width;
            y = (int)((double)y - dim.getHeight());
            c.setBounds(x, y, dim.width, dim.height);
            y -= this.gap;
        }
    }

    private boolean contains(Component comp) {
        return this.cc.contains(comp) || this.cc.contains(comp) || this.cb.contains(comp) || this.ct.contains(comp) || this.lt.contains(comp) || this.lc.contains(comp) || this.lb.contains(comp) || this.rt.contains(comp) || this.rc.contains(comp) || this.rb.contains(comp);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (this.contains(comp)) {
            return;
        }
        if (constraints == null) {
            this.cc.add(comp);
        } else if (constraints instanceof String) {
            String value = (String)constraints;
            value = value.toUpperCase();
            if (!(value = value.replaceAll(" ", "")).matches("[CLR],[CTB]")) {
                throw new IllegalArgumentException("Illegal constraints: " + value);
            }
            String[] vs = value.split(",");
            if (vs[0].equals("C") && vs[1].equals("T")) {
                this.ct.add(comp);
            } else if (vs[0].equals("C") && vs[1].equals("C")) {
                this.cc.add(comp);
            } else if (vs[0].equals("C") && vs[1].equals("B")) {
                this.cb.add(comp);
            } else if (vs[0].equals("L") && vs[1].equals("T")) {
                this.lt.add(comp);
            } else if (vs[0].equals("L") && vs[1].equals("C")) {
                this.lc.add(comp);
            } else if (vs[0].equals("L") && vs[1].equals("B")) {
                this.lb.add(comp);
            } else if (vs[0].equals("R") && vs[1].equals("T")) {
                this.rt.add(comp);
            } else if (vs[0].equals("R") && vs[1].equals("C")) {
                this.rc.add(comp);
            } else if (vs[0].equals("R") && vs[1].equals("B")) {
                this.rb.add(comp);
            }
        } else {
            throw new IllegalArgumentException("Wrong constraints for WidgetLayout: " + constraints.getClass().getSimpleName());
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return null;
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

