/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import tecgraf.openbus.OfferObserver;
import tecgraf.openbus.core.OfferRegistryImpl;
import tecgraf.openbus.core.RemoteOfferImpl;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferObserverPOA;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOfferDesc;

class OfferObserverImpl
extends OfferObserverPOA {
    public final OfferObserver observer;
    private final OfferRegistryImpl registry;
    private final RemoteOfferImpl remote;

    protected OfferObserverImpl(OfferRegistryImpl registry, OfferObserver observer, RemoteOfferImpl remote) {
        this.registry = registry;
        this.observer = observer;
        this.remote = remote;
    }

    @Override
    public void propertiesChanged(ServiceOfferDesc offer) {
        Thread t = new Thread(() -> {
            if (this.remote.offer() == null) {
                this.remote.offer(offer);
            }
            this.remote.updateProperties(RemoteOfferImpl.convertPropertiesToHashMap(offer.properties));
            this.observer.propertiesChanged(this.remote);
        });
        t.start();
    }

    @Override
    public void removed(ServiceOfferDesc offer) {
        if (this.remote.offer() == null) {
            this.remote.offer(offer);
        }
        this.registry.onOfferRemove(this.remote, true);
        Thread t = new Thread(() -> {
            this.observer.removed(this.remote);
            this.registry.onOfferRemove(this.remote, false);
            this.remote.removed();
        });
        t.start();
    }
}

