/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OfferSubscription;
import tecgraf.openbus.RemoteOffer;
import tecgraf.openbus.core.BusResource;
import tecgraf.openbus.core.OfferObserverImpl;
import tecgraf.openbus.core.OfferRegistryImpl;
import tecgraf.openbus.core.RemoteOfferImpl;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferObserver;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferObserverSubscription;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.exception.OpenBusInternalException;

class OfferSubscriptionImpl
extends BusResource
implements OfferSubscription {
    final OfferObserverImpl observer;
    final OfferObserver proxy;
    ServiceOfferDesc offerDesc;
    private OfferObserverSubscription sub = null;
    private final OfferRegistryImpl registry;
    private final RemoteOfferImpl offer;
    private static final Logger logger = Logger.getLogger(OfferSubscriptionImpl.class.getName());

    protected OfferSubscriptionImpl(OfferRegistryImpl registry, RemoteOfferImpl offer, OfferObserverImpl observer, OfferObserver proxy) {
        this.registry = registry;
        this.offer = offer;
        this.observer = observer;
        this.proxy = proxy;
        this.offerDesc = offer.offer();
    }

    @Override
    public Connection connection() {
        return this.registry.connection();
    }

    @Override
    public boolean subscribed() throws ServiceFailure {
        while (true) {
            try {
                return this.subscribed(Integer.MAX_VALUE);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subscribed(long timeoutMillis) throws ServiceFailure, TimeoutException {
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("O timeout deve ser positivo.");
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.sub == null && this.lastError == null && timeoutMillis >= 0L) {
                long initial = System.currentTimeMillis();
                this.checkLoggedOut();
                if (this.cancelled) {
                    return false;
                }
                try {
                    if (timeoutMillis > 0L) {
                        this.lock.wait(timeoutMillis);
                    }
                }
                catch (InterruptedException e) {
                    this.logInterruptError(logger, e);
                    Thread.currentThread().interrupt();
                    return false;
                }
                timeoutMillis -= System.currentTimeMillis() - initial;
            }
            this.checkLoggedOut();
            if (this.cancelled) {
                return false;
            }
            if (this.sub == null) {
                if (this.lastError == null) {
                    throw new TimeoutException("N\u00e3o foi poss\u00edvel verificar a subscri\u00e7\u00e3o \u00e0 oferta no tempo especificado.");
                }
                try {
                    throw this.lastError;
                }
                catch (Error | RuntimeException | ServiceFailure e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new OpenBusInternalException("Exce\u00e7\u00e3o inesperada ao tentar realizar uma subscri\u00e7\u00e3o de registro de oferta. Por favor contacte o administrador do sistema e informe-o sobre este erro.", e);
                }
            }
            return true;
        }
    }

    @Override
    public void remove() {
        this.cancel();
        this.registry.removeOfferSubscription(this);
        this.removeSub();
    }

    @Override
    public tecgraf.openbus.OfferObserver observer() {
        return this.observer.observer;
    }

    @Override
    public RemoteOffer offer() {
        return this.offer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(Exception error) {
        Object object = this.lock;
        synchronized (object) {
            this.sub = null;
            super.error(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loggedOut() {
        Object object = this.lock;
        synchronized (object) {
            super.loggedOut();
            this.removeSub();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sub(OfferObserverSubscription sub) {
        Object object = this.lock;
        synchronized (object) {
            this.sub = sub;
            this.lastError = null;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OfferObserverSubscription sub() {
        Object object = this.lock;
        synchronized (object) {
            return this.sub;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSub() {
        Object object = this.lock;
        synchronized (object) {
            this.sub = null;
            this.lastError = null;
            this.offerDesc = null;
            this.lock.notifyAll();
        }
    }
}

