/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.retry;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import tecgraf.openbus.retry.RetryContext;
import tecgraf.openbus.retry.RetryTask;

public class RetryTaskPool {
    private static final int DEFAULT_POOL_SIZE = 4;
    private final ListeningScheduledExecutorService pool;
    public final int poolSize;

    public RetryTaskPool() {
        this(4);
    }

    public RetryTaskPool(int size) {
        this.poolSize = size;
        this.pool = MoreExecutors.listeningDecorator(Executors.newScheduledThreadPool(size, task -> {
            Thread thread = new Thread(task);
            thread.setDaemon(true);
            thread.setName("RetryTaskPoolThread-" + thread.getId());
            return thread;
        }));
    }

    public <T> ListenableFuture<T> doTask(Callable<T> callable, RetryContext context) {
        RetryTask<T> retryTask = new RetryTask<T>(this.pool, callable, context);
        retryTask.execute();
        return retryTask.getFuture();
    }

    public ListenableFuture<Void> doTask(Runnable runnable, RetryContext context) {
        RetryTask retryTask = new RetryTask(this.pool, runnable, context);
        retryTask.execute();
        return retryTask.getFuture();
    }

    public ListeningScheduledExecutorService pool() {
        return this.pool;
    }
}

