package busexplorer.panel.configuration.admins;

import busexplorer.Application;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;

import javax.swing.JFrame;
import java.awt.event.ActionEvent;

/**
 * Classe de ao para editar um administrador. Esta dispara um dilogo.
 * 
 * 
 * @author Tecgraf
 */
public class AdminEditAction extends OpenBusAction<AdminWrapper> {

  /**
   * Construtor da ao.
   *  @param parentWindow janela me do dilogo que a ser criado pela ao
   *
   */
  public AdminEditAction(JFrame parentWindow) {
    super(parentWindow);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ActionType getActionType() {
    return ActionType.EDIT;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean abilityConditions() {
    return Application.login() != null && Application.login().hasAdminRights();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent arg0) {
    AdminInputDialog dialog = new AdminInputDialog(parentWindow,
      getTablePanelComponent());
    dialog.showDialog();
    AdminWrapper adminWrapper = getTablePanelComponent().getSelectedElement();
    dialog.setEditionMode(adminWrapper);
  }

}
