/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.certificates;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.certificates.CertificateWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FileUtils;

public class CertificateInputDialog
extends BusExplorerAbstractInputDialog {
    private JLabel identifierLabel;
    private JTextField identifierField;
    private JLabel certificateLabel;
    private JTextField certificateField;
    private JButton certificateButton;
    private TablePanelComponent<CertificateWrapper> panel;

    public CertificateInputDialog(Window parentWindow, TablePanelComponent<CertificateWrapper> panel) {
        super(parentWindow);
        this.panel = panel;
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                File certificateFile = new File(CertificateInputDialog.this.getCertificatePath());
                byte[] certificate = FileUtils.readFileToByteArray((File)certificateFile);
                Application.login().admin.registerCertificate(CertificateInputDialog.this.getIdentifier(), certificate);
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    CertificateInputDialog.this.panel.refresh(null);
                    CertificateInputDialog.this.panel.selectElement(new CertificateWrapper(CertificateInputDialog.this.getIdentifier()), true);
                }
            }
        };
        task.execute(this, Language.get(this.getClass(), "waiting.title"), Language.get(this.getClass(), "waiting.msg"));
        return task.getStatus();
    }

    @Override
    public JPanel buildFields() {
        this.setMinimumSize(new Dimension(380, 240));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill, flowy"));
        this.identifierLabel = new JLabel(Language.get(this.getClass(), "identifier.label"));
        panel.add((Component)this.identifierLabel, "grow");
        this.identifierField = new JTextField(30);
        this.identifierField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (CertificateInputDialog.this.identifierField.getText().trim().isEmpty()) {
                    CertificateInputDialog.this.setErrorMessage(Language.get(CertificateInputDialog.class, "error.validation.name"));
                } else {
                    CertificateInputDialog.this.clearErrorMessage();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        panel.add((Component)this.identifierField, "grow");
        this.certificateLabel = new JLabel(Language.get(this.getClass(), "certificate.label"));
        panel.add((Component)this.certificateLabel, "grow");
        JPanel certificatePane = new JPanel((LayoutManager)new MigLayout("", "[grow][]"));
        this.certificateField = new JTextField(30);
        this.certificateField.setEditable(false);
        certificatePane.add((Component)this.certificateField, "growx");
        this.certificateButton = new JButton(Language.get(this.getClass(), "certificate.search"));
        this.certificateButton.addActionListener(e -> {
            this.chooseCertificateFile();
            this.clearErrorMessage();
        });
        certificatePane.add((Component)this.certificateButton, "dock east");
        panel.add((Component)certificatePane, "grow, push");
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        if (this.getIdentifier().trim().isEmpty()) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.name"));
            return false;
        }
        if (this.getCertificatePath().isEmpty()) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.emptyPath"));
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    public void setEditionMode(CertificateWrapper info) {
        this.identifierField.setText(info.getEntity());
        this.identifierField.setEnabled(false);
    }

    public void chooseCertificateFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        int status = chooser.showOpenDialog(this);
        if (status == 0) {
            String certificatePath = chooser.getSelectedFile().getAbsolutePath();
            this.certificateField.setText(certificatePath);
        }
    }

    private String getIdentifier() {
        return this.identifierField.getText();
    }

    private String getCertificatePath() {
        return this.certificateField.getText();
    }
}

