/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.providers;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.contracts.ContractWrapper;
import busexplorer.panel.providers.ProviderInputDialog;
import busexplorer.panel.providers.ProviderWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.javautils.gui.StandardDialogs;

public class ProviderAddAction
extends OpenBusAction<ProviderWrapper> {
    public ProviderAddAction(JFrame parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ADD;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        BusExplorerTask<List<ContractWrapper>> task = new BusExplorerTask<List<ContractWrapper>>(ExceptionContext.Service){

            @Override
            protected void doPerformTask() throws Exception {
                this.setResult(ContractWrapper.convertToInfo(Application.login().extension.getContracts()));
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    List result = (List)this.getResult();
                    if (result.size() == 0) {
                        StandardDialogs.showErrorDialog((Component)this.parentWindow, (String)ProviderAddAction.this.getString("error.title"), (String)ProviderAddAction.this.getString("error.nocontracts"));
                    } else {
                        new ProviderInputDialog(ProviderAddAction.this.parentWindow, ProviderAddAction.this.getTablePanelComponent(), (List)this.getResult()).showDialog();
                    }
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

