/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.utils;

import busexplorer.utils.Language;
import java.util.Properties;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.ETF.Profile;
import tecgraf.openbus.admin.IncompatibleBus;

public class BusAddress {
    private String description;
    private String host;
    private short port;
    private String ior;
    private AddressType type;
    private static final ORB orb;
    public static final BusAddress UNSPECIFIED_ADDRESS;

    private BusAddress(String description, String host, short port) {
        this.description = description;
        this.host = host;
        this.port = port;
        this.type = AddressType.Address;
    }

    private BusAddress(String description, String ior) {
        this.description = description;
        this.ior = ior;
        this.type = AddressType.Reference;
    }

    private BusAddress() {
        this.description = Language.get(BusAddress.class, "unspecified");
        this.type = AddressType.Unspecified;
    }

    public void checkBusVersion() throws IncompatibleBus {
        String stringfiedIOR = this.toIOR();
        try {
            for (Profile profile : new ParsedIOR(orb, stringfiedIOR).getProfiles()) {
                String objectKey = new String(profile.get_object_key());
                if (objectKey.equals("OpenBus_2_0")) {
                    throw new IncompatibleBus(Language.get(BusAddress.class, "legacy.version.unsupported", stringfiedIOR));
                }
                if (!objectKey.equals("OpenBus_2_1")) continue;
                return;
            }
        }
        catch (BAD_PARAM | MARSHAL e) {
            throw new IllegalArgumentException(Language.get(BusAddress.class, "parsedior.fail", stringfiedIOR, e.toString()));
        }
        throw new IllegalArgumentException(stringfiedIOR);
    }

    public void checkBusReference() {
        if (orb.string_to_object(this.toIOR())._non_existent()) {
            throw new OBJECT_NOT_EXIST();
        }
    }

    public String toString() {
        String addressFormat = "%s:%s - SSL: %s";
        String text = "";
        switch (this.type) {
            case Address: {
                text = String.format(addressFormat, this.host, this.port, "off");
                break;
            }
            case Reference: {
                IIOPProfile profile = (IIOPProfile)new ParsedIOR(orb, this.ior).getProfiles().get(0);
                IIOPAddress address = (IIOPAddress)profile.getAddress();
                int sslPort = profile.getSSLPort();
                if (sslPort != -1) {
                    text = String.format(addressFormat, address.getIP(), sslPort, "on");
                    break;
                }
                text = String.format(addressFormat, address.getIP(), address.getPort(), "off");
                break;
            }
            case Unspecified: {
                return this.description;
            }
        }
        if (this.description != null) {
            text = this.description + " (" + text + ")";
        }
        return text;
    }

    public String getHost() {
        return this.host;
    }

    public short getPort() {
        return this.port;
    }

    public String getIOR() {
        return this.ior;
    }

    public String toIOR() {
        String corbaloc = "";
        switch (this.getType()) {
            case Address: {
                corbaloc = String.format("corbaloc::1.0@%s:%d/%s", this.getHost(), this.getPort(), "OpenBus_2_1");
                break;
            }
            case Reference: {
                corbaloc = this.ior;
            }
        }
        return corbaloc;
    }

    public String getDescription() {
        return this.description;
    }

    public AddressType getType() {
        return this.type;
    }

    public static BusAddress toAddress(String description, String addressStr) {
        BusAddress address;
        try {
            if (addressStr.matches("^IOR:.+") || addressStr.matches("^corbaloc:.+")) {
                address = new BusAddress(description, addressStr);
            } else {
                String[] addressContents = addressStr.split(":");
                short port = Short.parseShort(addressContents[1]);
                if (port < 0) {
                    throw new IllegalArgumentException();
                }
                address = new BusAddress(description, addressContents[0], port);
            }
        }
        catch (Exception e) {
            address = new BusAddress();
        }
        return address;
    }

    static {
        Properties props = new Properties();
        props.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        props.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        orb = (ORB)org.omg.CORBA.ORB.init((String[])new String[0], (Properties)props);
        UNSPECIFIED_ADDRESS = new BusAddress();
    }

    public static enum AddressType {
        Address,
        Reference,
        Unspecified;

    }
}

