/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.consumers;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.BusQueryHelpAction;
import busexplorer.panel.BusQueryValidateAction;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.consumers.ConsumerWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import busexplorer.utils.StringUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.omg.CORBA.BAD_PARAM;
import tecgraf.openbus.services.governance.v1_0.Consumer;

public class ConsumerInputDialog
extends BusExplorerAbstractInputDialog {
    private JTextField nameTextField;
    private JTextField codeTextField;
    private JTextField supportOfficeTextField;
    private JTextField managerOfficeTextField;
    private JTextField supportTextField;
    private JTextField managerTextField;
    private JTextArea queryTextField;
    private BusQueryValidateAction<JTextArea, String> queryValidation;
    private TablePanelComponent<ConsumerWrapper> panel;
    private ConsumerWrapper editingConsumer = null;

    public ConsumerInputDialog(Window parentWindow, TablePanelComponent<ConsumerWrapper> panel) {
        super(parentWindow);
        this.panel = panel;
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.Service){

            @Override
            protected void doPerformTask() throws Exception {
                if (ConsumerInputDialog.this.editingConsumer == null) {
                    Consumer consumer;
                    try {
                        consumer = Application.login().extension.getConsumerRegistry().add(ConsumerInputDialog.this.nameTextField.getText());
                    }
                    catch (BAD_PARAM e) {
                        throw new IllegalArgumentException(Language.get(ConsumerInputDialog.class, "error.alreadyinuse.name"), e);
                    }
                    consumer.code(ConsumerInputDialog.this.codeTextField.getText().trim());
                    consumer.supportoffice(ConsumerInputDialog.this.supportOfficeTextField.getText().trim());
                    consumer.manageroffice(ConsumerInputDialog.this.managerOfficeTextField.getText().trim());
                    consumer.support(StringUtilities.splitOmmitEmpty(ConsumerInputDialog.this.supportTextField.getText(), ",").toArray(new String[0]));
                    consumer.manager(StringUtilities.splitOmmitEmpty(ConsumerInputDialog.this.managerTextField.getText(), ",").toArray(new String[0]));
                    consumer.busquery(ConsumerInputDialog.this.queryTextField.getText().trim());
                    ConsumerInputDialog.this.editingConsumer = new ConsumerWrapper(consumer);
                } else {
                    try {
                        ConsumerInputDialog.this.editingConsumer.name(ConsumerInputDialog.this.nameTextField.getText().trim());
                    }
                    catch (BAD_PARAM e) {
                        throw new IllegalArgumentException(Language.get(ConsumerInputDialog.class, "error.alreadyinuse.name"), e);
                    }
                    ConsumerInputDialog.this.editingConsumer.code(ConsumerInputDialog.this.codeTextField.getText().trim());
                    ConsumerInputDialog.this.editingConsumer.supportoffice(ConsumerInputDialog.this.supportOfficeTextField.getText().trim());
                    ConsumerInputDialog.this.editingConsumer.manageroffice(ConsumerInputDialog.this.managerOfficeTextField.getText().trim());
                    ConsumerInputDialog.this.editingConsumer.support(StringUtilities.splitOmmitEmpty(ConsumerInputDialog.this.supportTextField.getText(), ","));
                    ConsumerInputDialog.this.editingConsumer.manager(StringUtilities.splitOmmitEmpty(ConsumerInputDialog.this.managerTextField.getText(), ","));
                    ConsumerInputDialog.this.editingConsumer.busquery(ConsumerInputDialog.this.queryTextField.getText().trim());
                }
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    ConsumerInputDialog.this.panel.refresh(null);
                    ConsumerInputDialog.this.panel.selectElement(ConsumerInputDialog.this.editingConsumer, true);
                }
            }
        };
        task.execute(this, Language.get(this.getClass(), "waiting.title"), Language.get(this.getClass(), "waiting.msg"));
        return task.getStatus();
    }

    @Override
    public JPanel buildFields() {
        this.setMinimumSize(new Dimension(400, 550));
        JPanel panel = new JPanel(new MigLayout("fill, flowy"));
        JLabel nameLabel = new JLabel(Language.get(this.getClass(), "name.label"));
        panel.add((Component)nameLabel, "grow");
        this.nameTextField = new JTextField();
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ConsumerInputDialog.this.hasValidFields();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        panel.add((Component)this.nameTextField, "grow");
        JLabel codeLabel = new JLabel(Language.get(this.getClass(), "code.label"));
        panel.add((Component)codeLabel, "grow");
        this.codeTextField = new JTextField();
        panel.add((Component)this.codeTextField, "grow");
        JLabel supportOfficeLabel = new JLabel(Language.get(this.getClass(), "supportoffice.label"));
        panel.add((Component)supportOfficeLabel, "grow");
        this.supportOfficeTextField = new JTextField();
        panel.add((Component)this.supportOfficeTextField, "grow");
        JLabel supportLabel = new JLabel(Language.get(this.getClass(), "support.label"));
        panel.add((Component)supportLabel, "grow");
        this.supportTextField = new JTextField();
        panel.add((Component)this.supportTextField, "grow");
        JLabel managerOfficeLabel = new JLabel(Language.get(this.getClass(), "manageroffice.label"));
        panel.add((Component)managerOfficeLabel, "grow");
        this.managerOfficeTextField = new JTextField();
        panel.add((Component)this.managerOfficeTextField, "grow");
        JLabel managerLabel = new JLabel(Language.get(this.getClass(), "manager.label"));
        panel.add((Component)managerLabel, "grow");
        this.managerTextField = new JTextField();
        panel.add((Component)this.managerTextField, "grow");
        JLabel queryLabel = new JLabel(Language.get(this.getClass(), "busquery.label"));
        panel.add((Component)queryLabel, "grow");
        this.queryTextField = new JTextArea(5, 20);
        this.queryTextField.setLineWrap(true);
        this.queryTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ConsumerInputDialog.this.hasValidFields();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.queryValidation = new BusQueryValidateAction<JTextArea, String>(this, this.queryTextField, jTextArea -> jTextArea.getText().trim());
        JPanel busQueryPanel = new JPanel(new MigLayout("wrap 2, ins 0", "[grow][]", "[grow][grow]"));
        busQueryPanel.add((Component)new JScrollPane(this.queryTextField), "grow, push, span 1 2");
        JPanel buttonsPanel = new JPanel(new MigLayout("flowy, ins 0"));
        buttonsPanel.add((Component)new JButton(this.queryValidation), "grow");
        buttonsPanel.add((Component)new JButton(new BusQueryHelpAction(this)), "grow");
        busQueryPanel.add((Component)buttonsPanel, "grow, gapbottom push");
        panel.add((Component)busQueryPanel, "grow, push, wrap");
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        if (this.nameTextField.getText().trim().isEmpty()) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.name"));
            return false;
        }
        if (!this.queryValidation.abilityConditions()) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.busquery"));
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    public void setEditionMode(ConsumerWrapper info) {
        this.editingConsumer = info;
        this.nameTextField.setText(info.name());
        this.codeTextField.setText(info.code());
        this.supportOfficeTextField.setText(info.supportoffice());
        this.managerOfficeTextField.setText(info.manageroffice());
        this.supportTextField.setText(String.join((CharSequence)", ", info.support()));
        this.managerTextField.setText(String.join((CharSequence)", ", info.manager()));
        this.queryTextField.setText(info.busquery());
    }
}

