/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.utils.preferences;

import java.util.Collection;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ApplicationPreferences {
    public static final String EMPTY = null;
    public static final String SCAPE_CHAR = "\\\\";
    public static final String SEP = ",";
    private Preferences preferences;

    public ApplicationPreferences(String appname) {
        this.preferences = Preferences.userRoot().node(appname);
    }

    private void write(Preferences preferences, String name, String value) {
        preferences.put(name, value);
    }

    public void write(String name, String value) {
        this.write(this.preferences, name, value);
    }

    public void write(String path, String name, String value) {
        this.write(this.preferences.node(path), name, value);
    }

    private String read(Preferences preferences, String name) {
        return preferences.get(name, EMPTY);
    }

    public String read(String name) {
        return this.read(this.preferences, name);
    }

    public String read(String path, String name) {
        return this.read(this.preferences.node(path), name);
    }

    private String scape(String item) {
        return item.replace(SEP, "\\\\,");
    }

    private String unscape(String item) {
        return item.replace("\\\\,", SEP);
    }

    private void write(Preferences preferences, String name, Collection<String> value) {
        String storeValue = value.stream().map(i -> this.scape((String)i)).collect(Collectors.joining(SEP));
        preferences.put(name, storeValue);
    }

    public void write(String name, Collection<String> value) {
        this.write(this.preferences, name, value);
    }

    public void write(String path, String name, Collection<String> value) {
        this.write(this.preferences.node(path), name, value);
    }

    public void addToCollection(String name, String value, boolean addIfExists) {
        Collection<String> items = this.readCollection(name);
        boolean exists = items.stream().filter(it -> it.equals(value)).findFirst().isPresent();
        if (!exists || exists && addIfExists) {
            items.add(value);
            this.write(name, items);
        }
    }

    public void addToCollection(String path, String name, String value, boolean addIfExists) {
        Collection<String> items = this.readCollection(path, name);
        boolean exists = items.stream().filter(it -> it.equals(value)).findFirst().isPresent();
        if (!exists || exists && addIfExists) {
            items.add(value);
            this.write(path, name, items);
        }
    }

    private Collection<String> readCollection(Preferences preferences, String name) {
        String storedValue = preferences.get(name, EMPTY);
        String[] items = storedValue == null ? new String[]{} : storedValue.split("(?<!\\\\),");
        return Stream.of(items).map(item -> this.unscape((String)item)).collect(Collectors.toList());
    }

    public Collection<String> readCollection(String name) {
        return this.readCollection(this.preferences, name);
    }

    public Collection<String> readCollection(String path, String name) {
        return this.readCollection(this.preferences.node(path), name);
    }
}

