/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import net.miginfocom.swing.MigLayout;

class ContentPanel
extends JPanel
implements Scrollable {
    private static final long serialVersionUID = 1L;

    public ContentPanel(LinkedHashMap<Component, Integer> contents) {
        this.setOpaque(false);
        this.setLayout(new MigLayout("ins 0 0 0 5, gapy 0, wrap 1", "grow"));
        boolean first = true;
        for (Map.Entry<Component, Integer> entry : contents.entrySet()) {
            Component comp = entry.getKey();
            int topGap = entry.getValue();
            if (first) {
                topGap = 0;
            }
            this.add(comp, "grow x, gaptop " + topGap);
            first = false;
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dim = this.getPreferredSize();
        if (!this.isPreferredSizeSet()) {
            dim.height = Math.min(dim.height, 150);
        }
        return dim;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 100;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (!this.isPreferredSizeSet()) {
            dim.width = Math.max(dim.width, 300);
        }
        return dim;
    }
}

