/*
 * Decompiled with CFR 0.152.
 */
package scs.core;

import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import scs.core.FacetDescription;
import scs.core.exception.SCSException;

public final class Facet {
    POA poa;
    private String name;
    private String interfaceName;
    private Servant servant;
    private Object reference;

    Facet(POA poa, String name, String interfaceName, Servant servant) throws SCSException {
        if (poa == null) {
            throw new IllegalArgumentException("The poa can't be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("The name can't be null");
        }
        if (interfaceName == null) {
            throw new IllegalArgumentException("The interface's name can't be null");
        }
        this.poa = poa;
        this.name = name;
        this.interfaceName = interfaceName;
        this.setServant(servant);
    }

    public FacetDescription getDescription() {
        return new FacetDescription(this.name, this.interfaceName, this.reference);
    }

    public String getName() {
        return this.name;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public Object getReference() {
        return this.reference;
    }

    public Servant getServant() {
        return this.servant;
    }

    void setServant(Servant servant) throws SCSException {
        if (servant == null) {
            throw new IllegalArgumentException("The servant can't be null");
        }
        if (this.servant != null) {
            this.deactivate();
        }
        this.servant = servant;
        this.checkForGetComponent();
        this.activate();
    }

    private void checkForGetComponent() {
        try {
            this.getClass().getMethod("_get_component", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void activate() throws SCSException {
        try {
            this.reference = this.poa.servant_to_reference(this.servant);
        }
        catch (UserException e) {
            throw new SCSException(e);
        }
    }

    void deactivate() throws SCSException {
        try {
            byte[] referenceId = this.poa.reference_to_id(this.reference);
            this.poa.deactivate_object(referenceId);
        }
        catch (UserException e) {
            throw new SCSException(e);
        }
    }

    public boolean equals(java.lang.Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Facet facet = (Facet)obj;
        return this.name.equals(facet.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

