/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.crud.demo.view;

import javax.swing.JLabel;
import javax.swing.JTextField;
import tecgraf.javautils.gui.crud.demo.logic.Plane;
import tecgraf.javautils.gui.crud.gui.edition.RegistrationEditionPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;
import tecgraf.javautils.gui.crud.utils.TextListeners;

public class PlaneEditPanel
extends RegistrationEditionPanel<Plane, Plane> {
    final JTextField nameText = new JTextField(20);
    final JTextField lenText = new JTextField(5);

    @Override
    public Plane getObjectFromIHC() {
        double l;
        try {
            l = Double.parseDouble(this.lenText.getText());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new Plane(this.nameText.getText(), l);
    }

    @Override
    public void setObjectToIHC(Plane plane) {
        this.nameText.setText(plane.name);
        this.lenText.setText(plane.lengthMeters + "");
    }

    @Override
    public void setReadOnlyIHC(boolean readOnly) {
        this.nameText.setEditable(!readOnly);
        this.lenText.setEditable(!readOnly);
    }

    @Override
    public void clearIHC() {
        this.nameText.setText(null);
        this.lenText.setText(null);
    }

    public PlaneEditPanel(RegistrationMainPanel<Plane, Plane> mainPanel) {
        super(mainPanel);
        this.getContainer().add(new JLabel("Nome:"));
        this.getContainer().add(this.nameText);
        this.getContainer().add(new JLabel("Comp.:"));
        this.getContainer().add(this.lenText);
        TextListeners.addTextListener(this.nameText, mainPanel);
        TextListeners.addTextListener(this.lenText, mainPanel);
    }
}

