/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.field;

import javax.swing.text.BadLocationException;
import tecgraf.javautils.gui.field.CompleteText;
import tecgraf.javautils.gui.field.RegexDocument;

public class LatLongDocument
extends RegexDocument {
    private Orientation orientation;
    private String maxSizeDegree;
    private int decimal;
    private boolean hemisphereEnabled;

    public LatLongDocument(Orientation orientation) {
        this(orientation, 2, true);
    }

    public LatLongDocument(Orientation orientation, int decimal) {
        this(orientation, decimal, true);
    }

    public LatLongDocument(Orientation orientation, boolean hemisphereEnabled) {
        this(orientation, 2, hemisphereEnabled);
    }

    public LatLongDocument(Orientation orientation, int decimal, boolean hemisphereEnabled) {
        super(LatLongDocument.getRegex(hemisphereEnabled, orientation, decimal), LatLongDocument.buildAutoComplete(hemisphereEnabled, orientation, decimal, true));
        this.hemisphereEnabled = hemisphereEnabled;
        this.orientation = orientation;
        this.maxSizeDegree = orientation == Orientation.LONGITUDE ? "3" : "2";
        this.setDecimal(decimal);
    }

    protected void rebuildCompleText() {
        this.setCompleteText(LatLongDocument.buildAutoComplete(this.hemisphereEnabled, this.orientation, this.decimal, true));
    }

    private static CompleteText buildAutoComplete(final boolean hemisphereEnabled, final Orientation orientation, int decimal, boolean enabled) {
        if (enabled) {
            final int newDecimal = LatLongDocument.normalizeDecimal(decimal);
            return new CompleteText(){

                @Override
                public String buildCompletedText(String text, String newStr) {
                    String hem = "";
                    if (hemisphereEnabled) {
                        hem = "\\-?";
                    }
                    String maxSizeDegree = "";
                    maxSizeDegree = orientation == Orientation.LONGITUDE ? "3" : "2";
                    String regex1 = hem + "[0-9]{" + maxSizeDegree + "}";
                    String regex2 = hem + "[0-9]{1," + maxSizeDegree + "}:[0-9]{2}";
                    String regex3 = hem + "[0-9]{1," + maxSizeDegree + "}:[0-9]{1,2}:[0-9]{2}";
                    String complt1 = "[0-9]{1,2}(:([0-9]{1,2}(\\.([0-9]{1," + newDecimal + "})?)?)?)?";
                    String complt2 = "[0-9]{1,2}(\\.([0-9]{1," + newDecimal + "})?)?";
                    String complt3 = "([0-9]{1," + newDecimal + "})?";
                    String regex1Longitude = hem + "[0-9]{2}";
                    if (orientation == Orientation.LONGITUDE && text.matches(regex1Longitude) && newStr.matches(complt1)) {
                        String s = newStr.split(":")[0];
                        int degree = Math.abs(Integer.parseInt(text + s));
                        if (degree > 180) {
                            return ":" + newStr;
                        }
                    }
                    if (text.matches(regex1) && newStr.matches(complt1)) {
                        return ":" + newStr;
                    }
                    if (text.matches(regex2) && newStr.matches(complt2)) {
                        return ":" + newStr;
                    }
                    if (text.matches(regex3) && newStr.matches(complt3)) {
                        return "." + newStr;
                    }
                    return newStr;
                }
            };
        }
        return null;
    }

    public void setAutoComplete(boolean complete) {
        this.setCompleteText(LatLongDocument.buildAutoComplete(this.hemisphereEnabled, this.orientation, this.decimal, true));
    }

    public boolean isValid() {
        String hem = "";
        if (this.hemisphereEnabled) {
            hem = "\\-?";
        }
        String validRegex = hem + "[0-9]{1," + this.maxSizeDegree + "}:[0-9]{1,2}:[0-9]{1,2}(\\.[0-9]{1," + this.decimal + "})?";
        String text = this.getText();
        if (text.matches(validRegex)) {
            String[] str = text.split(":");
            int degree = Math.abs(Integer.parseInt(str[0]));
            int minute = Math.abs(Integer.parseInt(str[1]));
            float second = Math.abs(Float.parseFloat(str[2]));
            if (this.orientation == Orientation.LONGITUDE && degree >= 0 && degree <= 180 && minute <= 60 && second <= 60.0f) {
                return true;
            }
            if (this.orientation == Orientation.LATITUDE && degree >= 0 && degree <= 90 && minute <= 60 && second <= 60.0f) {
                return true;
            }
        }
        return false;
    }

    private static String getRegex(boolean hemisphereEnabled, Orientation orientation, int decimal) {
        decimal = LatLongDocument.normalizeDecimal(decimal);
        String hem = "";
        if (hemisphereEnabled) {
            hem = "(\\-)?";
        }
        String maxSizeDegree = "";
        maxSizeDegree = orientation == Orientation.LONGITUDE ? "3" : "2";
        return hem + "([0-9]{1," + maxSizeDegree + "})?(:)?([0-9]{1,2})?(:)?([0-9]{1,2})?(\\.)?([0-9]{1," + decimal + "})?";
    }

    public void setDecimal(int decimal) {
        this.decimal = LatLongDocument.normalizeDecimal(decimal);
    }

    private static int normalizeDecimal(int decimal) {
        if (decimal >= 1) {
            return decimal;
        }
        return 1;
    }

    public Integer getDegree() {
        if (this.isValid()) {
            String[] str = this.getText().split(":");
            Integer degree = Integer.parseInt(str[0]);
            return degree;
        }
        return null;
    }

    public Integer getMinute() {
        if (this.isValid()) {
            String[] str = this.getText().split(":");
            Integer minute = Integer.parseInt(str[1]);
            return minute;
        }
        return null;
    }

    public Float getSecond() {
        if (this.isValid()) {
            String[] str = this.getText().split(":");
            Float second = Float.valueOf(Float.parseFloat(str[2]));
            return second;
        }
        return null;
    }

    private String getText() {
        try {
            return this.getText(0, this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isHemisphereEnabled() {
        return this.hemisphereEnabled;
    }

    @Override
    protected Object getValue() {
        return this.getText();
    }

    public static enum Orientation {
        LATITUDE,
        LONGITUDE;

    }
}

