/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.searchpanel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.searchpanel.AbstractSearchView;

public class SearchPanel
extends JPanel {
    public static final String SEARCH_FIELD = "SEARCH_FIELD";
    private AbstractSearchView searchComponent;
    private boolean isFocusLostDesirable;

    public SearchPanel(AbstractSearchView searchComponent, boolean isFocusLostDesirable) {
        this.searchComponent = searchComponent;
        this.isFocusLostDesirable = isFocusLostDesirable;
        this.build();
    }

    public SearchPanel(AbstractSearchView searchComponent) {
        this(searchComponent, true);
    }

    private void build() {
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridBag);
        JLabel searchLabel = new JLabel(LNG.get("tecgraf.javautils.gui.searchpanel.label"));
        searchLabel.setDisplayedMnemonic(LNG.get("tecgraf.javautils.gui.searchpanel.label.mnemonic").charAt(0));
        c.insets = new Insets(5, 5, 0, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 17;
        gridBag.setConstraints(searchLabel, c);
        this.add(searchLabel);
        JTextField searchField = this.makeSearchField();
        searchField.setName(SEARCH_FIELD);
        searchLabel.setLabelFor(searchField);
        c.insets = new Insets(5, 5, 0, 5);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 2;
        gridBag.setConstraints(searchField, c);
        this.add(searchField);
    }

    private JTextField makeSearchField() {
        final JTextField searchField = new JTextField(12);
        searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 114) {
                    SearchPanel.this.searchComponent.selectSearchNext(searchField.getText().toUpperCase());
                } else {
                    SearchPanel.this.searchComponent.selectSearch(searchField.getText().toUpperCase(), false);
                }
            }
        });
        if (this.isFocusLostDesirable) {
            searchField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    searchField.setText("");
                }
            });
        }
        return searchField;
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (Component com : this.getComponents()) {
            com.setEnabled(enabled);
        }
    }
}

