/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.desktop.dialog;

import busexplorer.Application;
import busexplorer.ApplicationIcons;
import busexplorer.BusExplorerLogin;
import busexplorer.desktop.dialog.JComboBoxKeyAdapterMaxLength;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.utils.BusAddress;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import busexplorer.utils.preferences.ApplicationPreferences;
import busexplorer.utils.preferences.BusExplorerPrefs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import tecgraf.javautils.gui.GBC;

public class LoginDialog
extends JDialog {
    private JComboBox comboDomain;
    private JComboBox fieldAddress;
    private JTextField fieldUser;
    private JPasswordField fieldPassword;
    private JButton buttonLogin;
    private BusExplorerLogin login;
    private ApplicationPreferences prefs = BusExplorerPrefs.instance();

    public LoginDialog(Window owner) {
        super(owner, Language.get(LoginDialog.class, "title"), Dialog.ModalityType.APPLICATION_MODAL);
        this.buildDialog();
    }

    private void buildDialog() {
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LoginDialog.this.getOwner().dispose();
                System.exit(0);
            }
        });
        this.buildLoginPane();
        this.setLocationRelativeTo(this.getOwner());
    }

    public BusExplorerLogin getLogin() {
        return this.login;
    }

    private void buildLoginPane() {
        JPanel loginPanel = new JPanel(new BorderLayout());
        loginPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        JPanel configPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy"));
        Font FONT_LABEL = new Font("Dialog", 0, 12);
        EnableLoginListener enableLoginListener = new EnableLoginListener();
        SelectAllTextListener selectAllTextListener = new SelectAllTextListener();
        String[] addresses = this.prefs.readCollection("addresses").toArray(new String[0]);
        JLabel labelHost = new JLabel(Language.get(this.getClass(), "host.label"));
        labelHost.setFont(FONT_LABEL);
        configPanel.add((Component)labelHost, "grow");
        this.fieldAddress = new JComboBox<String>(new DefaultComboBoxModel<String>(addresses));
        this.fieldAddress.setEditable(true);
        new JComboBoxKeyAdapterMaxLength(this.fieldAddress, 30);
        this.fieldAddress.setToolTipText(Language.get(this.getClass(), "host.help"));
        this.fieldAddress.addFocusListener(selectAllTextListener);
        this.fieldAddress.addItemListener(enableLoginListener);
        this.fieldAddress.addActionListener(al -> {
            if ("comboBoxChanged".equals(al.getActionCommand())) {
                JComboBox jComboBox = (JComboBox)al.getSource();
                String host = (String)jComboBox.getSelectedItem();
                this.fieldUser.setText(this.prefs.read(host, "lastuser"));
                this.comboDomain.removeAllItems();
                this.prefs.readCollection(host, "domains").forEach(item -> this.comboDomain.addItem(item));
                if (this.comboDomain.getItemCount() > 0) {
                    this.comboDomain.setSelectedIndex(0);
                }
            }
        });
        this.fieldAddress.setFocusable(true);
        configPanel.add((Component)this.fieldAddress, "grow");
        JLabel labelUser = new JLabel(Language.get(this.getClass(), "user.label"));
        labelUser.setFont(FONT_LABEL);
        configPanel.add((Component)labelUser, "grow");
        this.fieldUser = new JTextField();
        this.fieldUser.setToolTipText(Language.get(this.getClass(), "user.help"));
        this.fieldUser.addFocusListener(selectAllTextListener);
        this.fieldUser.getDocument().addDocumentListener(enableLoginListener);
        this.fieldUser.setFocusable(true);
        configPanel.add((Component)this.fieldUser, "grow");
        JLabel labelPassword = new JLabel(Language.get(this.getClass(), "password.label"));
        labelPassword.setFont(FONT_LABEL);
        configPanel.add((Component)labelPassword, "grow");
        this.fieldPassword = new JPasswordField();
        this.fieldPassword.setToolTipText(Language.get(this.getClass(), "password.help"));
        this.fieldPassword.addFocusListener(selectAllTextListener);
        this.fieldPassword.setFocusable(true);
        configPanel.add((Component)this.fieldPassword, "grow");
        JPanel domainPanel = new JPanel((LayoutManager)new MigLayout("ins 0, fill", "[][]", "[]"));
        JLabel labelDomain = new JLabel(Language.get(this.getClass(), "domain.label"));
        labelDomain.setFont(FONT_LABEL);
        domainPanel.add((Component)labelDomain, "grow, wrap");
        this.comboDomain = new JComboBox();
        new JComboBoxKeyAdapterMaxLength(this.comboDomain, 30);
        this.comboDomain.setEditable(true);
        this.comboDomain.setToolTipText(Language.get(this.getClass(), "domain.help"));
        this.comboDomain.addFocusListener(selectAllTextListener);
        this.comboDomain.setFocusable(true);
        domainPanel.add((Component)this.comboDomain, "grow, push");
        configPanel.add((Component)domainPanel, "grow");
        loginPanel.add((Component)configPanel, "Center");
        this.buttonLogin = new JButton(Language.get(this.getClass(), "confirm.button"));
        this.buttonLogin.setMnemonic(Language.get(this.getClass(), "confirm.button.mnemonic").charAt(0));
        this.buttonLogin.setToolTipText(Language.get(this.getClass(), "confirm.help"));
        this.buttonLogin.addActionListener(new LoginAction());
        this.buttonLogin.setIcon(ApplicationIcons.ICON_LOGIN_16);
        this.buttonLogin.setEnabled(false);
        if (this.fieldAddress.getItemCount() > 0) {
            this.fieldAddress.setSelectedIndex(0);
        }
        Box buttonsBox = Box.createHorizontalBox();
        buttonsBox.setBorder(new EmptyBorder(9, 3, 3, 3));
        buttonsBox.add(Box.createHorizontalGlue());
        buttonsBox.add(this.buttonLogin);
        loginPanel.add((Component)buttonsBox, "South");
        JPanel leftBox = new JPanel(new GridBagLayout());
        leftBox.add(new JLabel(new ImageIcon(ApplicationIcons.BUSEXPLORER_LIST[ApplicationIcons.BUSEXPLORER_LIST.length - 1])));
        String[] version = Application.version();
        JLabel apiVersion = new JLabel(version[0]);
        apiVersion.setFont(new Font(apiVersion.getFont().getFontName(), 0, (int)((double)apiVersion.getFont().getSize() * 1.5)));
        leftBox.add((Component)apiVersion, new GBC(0, 1).insets(10));
        JLabel appVersion = new JLabel(version[1]);
        appVersion.setFont(new Font(appVersion.getFont().getFontName(), 0, (int)((double)appVersion.getFont().getSize() * 1.2)));
        leftBox.add((Component)appVersion, new GBC(0, 2).insets(10));
        loginPanel.add((Component)leftBox, "West");
        this.setContentPane(loginPanel);
        this.getRootPane().setDefaultButton(this.buttonLogin);
        this.pack();
        this.fillLoginForm();
    }

    private void fillLoginForm() {
        String propertyHost = System.getProperty("host");
        String propertyPort = System.getProperty("port");
        try {
            Integer.parseInt(propertyPort);
        }
        catch (NumberFormatException e) {
            propertyPort = null;
        }
        if (propertyHost == null && propertyPort == null) {
            this.fieldAddress.requestFocus();
        } else {
            this.fieldAddress.getEditor().setItem(propertyHost);
            if (propertyHost == null) {
                this.fieldAddress.requestFocus();
            } else {
                this.fieldUser.requestFocus();
            }
        }
    }

    private class EnableLoginListener
    implements DocumentListener,
    ItemListener {
        private EnableLoginListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.validate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.validate();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.validate();
        }

        private void validate() {
            String text = ((String)LoginDialog.this.fieldAddress.getEditor().getItem()).trim();
            BusAddress address = BusAddress.toAddress(null, text);
            if (text.length() > 0 && !address.getType().equals((Object)BusAddress.AddressType.Unspecified) && LoginDialog.this.fieldUser.getText().trim().length() > 0) {
                LoginDialog.this.buttonLogin.setEnabled(true);
            } else {
                LoginDialog.this.buttonLogin.setEnabled(false);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getItem() != null) {
                this.validate();
            }
        }
    }

    private class LoginAction
    implements ActionListener {
        private LoginAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.LoginByPassword){
                BusExplorerLogin theLogin;

                @Override
                protected void doPerformTask() throws Exception {
                    String host = LoginDialog.this.fieldAddress.getEditor().getItem().toString().trim();
                    BusAddress address = BusAddress.toAddress(null, host);
                    String entity = LoginDialog.this.fieldUser.getText().trim();
                    String domain = LoginDialog.this.comboDomain.getSelectedItem() == null ? "" : LoginDialog.this.comboDomain.getSelectedItem().toString().trim();
                    String password = new String(LoginDialog.this.fieldPassword.getPassword());
                    this.theLogin = new BusExplorerLogin(address, entity, domain);
                    this.theLogin.doLogin(password);
                    LoginDialog.this.prefs.addToCollection("addresses", host, false);
                    LoginDialog.this.prefs.write(host, "lastuser", entity);
                    LoginDialog.this.prefs.addToCollection(host, "domains", domain, false);
                }

                protected void afterTaskUI() {
                    if (this.getStatus()) {
                        LoginDialog.this.dispose();
                        LoginDialog.this.login = this.theLogin;
                    } else {
                        if (this.theLogin != null) {
                            this.theLogin.logout();
                        }
                        LoginDialog.this.fieldUser.requestFocus();
                    }
                }
            };
            task.execute(LoginDialog.this, Language.get(LoginDialog.class, "waiting.title"), Language.get(LoginDialog.class, "waiting.msg"), 2, 0);
        }
    }

    private class SelectAllTextListener
    extends FocusAdapter {
        private SelectAllTextListener() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            if (event.getComponent() instanceof JTextField) {
                ((JTextField)event.getComponent()).selectAll();
            } else if (event.getComponent() instanceof JComboBox) {
                ((JComboBox)event.getComponent()).getEditor().selectAll();
            }
        }
    }
}

