/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.contracts;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.contracts.ContractInputDialog;
import busexplorer.panel.contracts.ContractWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;

public class ContractEditAction
extends OpenBusAction<ContractWrapper> {
    public ContractEditAction(JFrame parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.EDIT;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        BusExplorerTask<List<String>> task = new BusExplorerTask<List<String>>(ExceptionContext.Service){

            @Override
            protected void doPerformTask() throws Exception {
                this.setResult(Application.login().admin.getInterfaces());
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    ContractInputDialog dialog = new ContractInputDialog(ContractEditAction.this.parentWindow, ContractEditAction.this.getTablePanelComponent(), (List)this.getResult());
                    dialog.showDialog();
                    ContractWrapper contract = (ContractWrapper)ContractEditAction.this.getTablePanelComponent().getSelectedElement();
                    dialog.setEditionMode(contract);
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

