/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.entities;

import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.entities.EntityWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.EntityCategory;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.EntityCategoryDesc;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntity;

public class EntityInputDialog
extends BusExplorerAbstractInputDialog {
    private JLabel entityIDLabel;
    private JTextField entityIDField;
    private JLabel categoryIDLabel;
    private JComboBox categoryIDCombo;
    private JLabel entityNameLabel;
    private JTextArea entityNameField;
    private TreeMap<String, EntityCategoryDesc> categories = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private TablePanelComponent<EntityWrapper> panel;
    private EntityWrapper editingEntity = null;

    public EntityInputDialog(Window parentWindow, TablePanelComponent<EntityWrapper> panel, List<EntityCategoryDesc> categoryDescList) {
        super(parentWindow);
        this.panel = panel;
        for (EntityCategoryDesc desc : categoryDescList) {
            this.categories.put(desc.id, desc);
        }
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){
            RegisteredEntity entity;

            @Override
            protected void doPerformTask() throws Exception {
                if (EntityInputDialog.this.editingEntity == null) {
                    EntityCategory category = ((EntityInputDialog)EntityInputDialog.this).getCategory().ref;
                    this.entity = category.registerEntity(EntityInputDialog.this.getEntityId(), EntityInputDialog.this.getEntityName());
                } else {
                    this.entity = ((EntityInputDialog)EntityInputDialog.this).editingEntity.getDescriptor().ref;
                    this.entity.setName(EntityInputDialog.this.getEntityName());
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    EntityInputDialog.this.panel.refresh(null);
                    EntityInputDialog.this.panel.selectElement(new EntityWrapper(this.entity.describe()), true);
                }
            }
        };
        task.execute(this, Language.get(this.getClass(), "waiting.title"), Language.get(this.getClass(), "waiting.msg"));
        return task.getStatus();
    }

    @Override
    public JPanel buildFields() {
        this.setMinimumSize(new Dimension(300, 300));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill, flowy"));
        this.categoryIDLabel = new JLabel(Language.get(this.getClass(), "categoryID.label"));
        panel.add((Component)this.categoryIDLabel, "grow");
        this.categoryIDCombo = new JComboBox<String>(this.categories.keySet().toArray(new String[this.categories.size()]));
        panel.add((Component)this.categoryIDCombo, "grow");
        this.entityIDLabel = new JLabel(Language.get(this.getClass(), "entityID.label"));
        panel.add((Component)this.entityIDLabel, "grow");
        this.entityIDField = new JTextField();
        this.entityIDField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (EntityInputDialog.this.entityIDField.getText().trim().isEmpty()) {
                    EntityInputDialog.this.setErrorMessage(Language.get(EntityInputDialog.class, "error.validation.name"));
                } else {
                    EntityInputDialog.this.clearErrorMessage();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        panel.add((Component)this.entityIDField, "grow");
        this.entityNameLabel = new JLabel(Language.get(this.getClass(), "entityName.label"));
        panel.add((Component)this.entityNameLabel, "grow");
        this.entityNameField = new JTextArea(5, 20);
        this.entityNameField.setLineWrap(true);
        panel.add((Component)new JScrollPane(this.entityNameField), "grow, push");
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        if (this.entityIDField.getText().trim().isEmpty()) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.name"));
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    public void setEditionMode(EntityWrapper info) {
        this.editingEntity = info;
        this.categoryIDCombo.setSelectedItem(info.getCategory());
        this.categoryIDCombo.setEnabled(false);
        this.entityIDField.setText(info.getId());
        this.entityIDField.setEnabled(false);
        this.entityNameField.setText(info.getName());
    }

    private String getEntityId() {
        return this.entityIDField.getText();
    }

    private String getEntityName() {
        return this.entityNameField.getText();
    }

    private EntityCategoryDesc getCategory() {
        return this.categories.get(this.categoryIDCombo.getSelectedItem());
    }
}

