/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;

public final class ReplaceTokens
extends BaseParamFilterReader
implements ChainableReader {
    private static final char DEFAULT_BEGIN_TOKEN = '@';
    private static final char DEFAULT_END_TOKEN = '@';
    private String queuedData = null;
    private String replaceData = null;
    private int replaceIndex = -1;
    private int queueIndex = -1;
    private Hashtable hash = new Hashtable();
    private char beginToken = (char)64;
    private char endToken = (char)64;

    public ReplaceTokens() {
    }

    public ReplaceTokens(Reader in) {
        super(in);
    }

    private int getNextChar() throws IOException {
        if (this.queueIndex != -1) {
            char ch = this.queuedData.charAt(this.queueIndex++);
            if (this.queueIndex >= this.queuedData.length()) {
                this.queueIndex = -1;
            }
            return ch;
        }
        return this.in.read();
    }

    public int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        if (this.replaceIndex != -1) {
            char ch = this.replaceData.charAt(this.replaceIndex++);
            if (this.replaceIndex >= this.replaceData.length()) {
                this.replaceIndex = -1;
            }
            return ch;
        }
        int ch = this.getNextChar();
        if (ch == this.beginToken) {
            StringBuffer key = new StringBuffer("");
            while ((ch = this.getNextChar()) != -1) {
                key.append((char)ch);
                if (ch != this.endToken) continue;
            }
            if (ch == -1) {
                this.queuedData = this.queuedData == null || this.queueIndex == -1 ? key.toString() : key.toString() + this.queuedData.substring(this.queueIndex);
                this.queueIndex = this.queuedData.length() > 0 ? 0 : -1;
                return this.beginToken;
            }
            key.setLength(key.length() - 1);
            String replaceWith = (String)this.hash.get(key.toString());
            if (replaceWith != null) {
                if (replaceWith.length() > 0) {
                    this.replaceData = replaceWith;
                    this.replaceIndex = 0;
                }
                return this.read();
            }
            String newData = key.toString() + this.endToken;
            this.queuedData = this.queuedData == null || this.queueIndex == -1 ? newData : newData + this.queuedData.substring(this.queueIndex);
            this.queueIndex = 0;
            return this.beginToken;
        }
        return ch;
    }

    public void setBeginToken(char beginToken) {
        this.beginToken = beginToken;
    }

    private char getBeginToken() {
        return this.beginToken;
    }

    public void setEndToken(char endToken) {
        this.endToken = endToken;
    }

    private char getEndToken() {
        return this.endToken;
    }

    public void setPropertiesResource(Resource r) {
        this.makeTokensFromProperties(r);
    }

    public void addConfiguredToken(Token token2) {
        this.hash.put(token2.getKey(), token2.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties(Resource r) {
        InputStream in = null;
        Properties props = new Properties();
        try {
            in = r.getInputStream();
            props.load(in);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            FileUtils.close(in);
        }
        return props;
    }

    private void setTokens(Hashtable hash) {
        this.hash = hash;
    }

    private Hashtable getTokens() {
        return this.hash;
    }

    public Reader chain(Reader rdr) {
        ReplaceTokens newFilter = new ReplaceTokens(rdr);
        newFilter.setBeginToken(this.getBeginToken());
        newFilter.setEndToken(this.getEndToken());
        newFilter.setTokens(this.getTokens());
        newFilter.setInitialized(true);
        return newFilter;
    }

    private void initialize() {
        Parameter[] params = this.getParameters();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                String value;
                String name;
                if (params[i] == null) continue;
                String type = params[i].getType();
                if ("tokenchar".equals(type)) {
                    name = params[i].getName();
                    value = params[i].getValue();
                    if ("begintoken".equals(name)) {
                        if (value.length() == 0) {
                            throw new BuildException("Begin token cannot be empty");
                        }
                        this.beginToken = params[i].getValue().charAt(0);
                        continue;
                    }
                    if (!"endtoken".equals(name)) continue;
                    if (value.length() == 0) {
                        throw new BuildException("End token cannot be empty");
                    }
                    this.endToken = params[i].getValue().charAt(0);
                    continue;
                }
                if ("token".equals(type)) {
                    name = params[i].getName();
                    value = params[i].getValue();
                    this.hash.put(name, value);
                    continue;
                }
                if (!"propertiesfile".equals(type)) continue;
                this.makeTokensFromProperties(new FileResource(new File(params[i].getValue())));
            }
        }
    }

    private void makeTokensFromProperties(Resource r) {
        Properties props = this.getProperties(r);
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = props.getProperty(key);
            this.hash.put(key, value);
        }
    }

    public static class Token {
        private String key;
        private String value;

        public final void setKey(String key) {
            this.key = key;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getKey() {
            return this.key;
        }

        public final String getValue() {
            return this.value;
        }
    }
}

