/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.etf;

import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Connection;
import org.omg.ETF.Listener;
import org.omg.ETF.Profile;
import org.omg.ETF._FactoriesLocalBase;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfileHolder;
import org.omg.RTCORBA.ProtocolProperties;

public abstract class FactoriesBase
extends _FactoriesLocalBase
implements Configurable {
    protected Configuration configuration;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException();
        }
        this.configuration = configuration;
    }

    @Override
    public Connection create_connection(ProtocolProperties props) {
        Connection result = this.create_connection_internal();
        this.configureResult(result);
        return result;
    }

    protected abstract Connection create_connection_internal();

    @Override
    public Listener create_listener(ProtocolProperties props, int stacksize, short base_priority) {
        return this.create_listener_internal();
    }

    protected abstract Listener create_listener_internal();

    @Override
    public abstract Profile demarshal_profile(TaggedProfileHolder var1, TaggedComponentSeqHolder var2);

    public ProtocolAddressBase create_protocol_address(String addr) {
        ProtocolAddressBase address = this.create_address_internal();
        int address_start = this.match_tag(addr);
        if (address_start >= 0 && !address.fromString(addr.substring(address_start + 2))) {
            throw new INTERNAL("Invalid protocol address string: " + address);
        }
        return address;
    }

    protected abstract ProtocolAddressBase create_address_internal();

    public int match_tag(String address) {
        return -1;
    }

    @Override
    public abstract Profile decode_corbaloc(String var1);

    protected void configureResult(Object o) {
        if (o instanceof Configurable) {
            try {
                ((Configurable)o).configure(this.configuration);
            }
            catch (ConfigurationException e) {
                throw new INTERNAL("ConfigurationException: " + e.toString());
            }
        }
    }
}

