/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Configs;
import demo.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import org.omg.CORBA.ORB;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.services.collaboration.easy.EasyCollaboration;
import tecgraf.openbus.services.collaboration.easy.IEasyCollaboration;

public class Sender
extends JFrame
implements ActionListener {
    private static Connection conn;
    private static OpenBusContext context;
    private static IEasyCollaboration easy;
    private final GridBagConstraints constraints;
    public final Border border = BorderFactory.createLoweredBevelBorder();
    protected final JTextField keyText;
    final JButton startButton;
    final JButton stopButton;
    final JButton sendButton;
    private StartTask startTask;
    private StopTask stopTask;
    private SendTask sendTask;

    private JTextField makeText() {
        JTextField t = new JTextField(20);
        t.setEditable(true);
        t.setHorizontalAlignment(4);
        t.setBorder(this.border);
        this.getContentPane().add((Component)t, this.constraints);
        return t;
    }

    private JButton makeButton(String caption) {
        JButton b = new JButton(caption);
        b.setActionCommand(caption);
        b.addActionListener(this);
        this.getContentPane().add((Component)b, this.constraints);
        return b;
    }

    public Sender() {
        super("Sender");
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.insets = new Insets(3, 10, 3, 10);
        this.keyText = this.makeText();
        this.startButton = this.makeButton("Start");
        this.stopButton = this.makeButton("Stop");
        this.stopButton.setEnabled(false);
        this.sendButton = this.makeButton("Send");
        this.sendButton.setEnabled(false);
        this.pack();
        this.setVisible(true);
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "Start": {
                this.startTask = new StartTask();
                this.startTask.execute();
                break;
            }
            case "Stop": {
                this.stopTask = new StopTask();
                this.stopTask.execute();
                break;
            }
            case "Send": {
                this.sendTask = new SendTask();
                this.sendTask.execute();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Configs configs = Configs.readConfigsFile();
        String entity = configs.user;
        byte[] password = configs.password;
        String host = configs.bushost;
        int port = configs.busport;
        ORB orb = ORBInitializer.initORB((String[])args);
        new Utils.ORBRunThread(orb).start();
        Utils.ShutdownThread shutdown = new Utils.ShutdownThread(orb);
        Runtime.getRuntime().addShutdownHook(shutdown);
        context = (OpenBusContext)orb.resolve_initial_references("OpenBusContext");
        conn = context.createConnection(host, port);
        context.setDefaultConnection(conn);
        conn.loginByPassword(entity, password);
        shutdown.addConnection(conn);
        easy = new EasyCollaboration(context);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Sender();
            }
        });
    }

    private class SendTask
    extends SwingWorker<Void, Void> {
        private SendTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            easy.shareDataKey(Sender.this.keyText.getText().getBytes());
            return null;
        }

        @Override
        protected void done() {
            Sender.this.keyText.setText(null);
        }
    }

    private class StopTask
    extends SwingWorker<Void, Void> {
        private StopTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            easy.exitCollaboration();
            return null;
        }

        @Override
        protected void done() {
            Sender.this.startButton.setEnabled(true);
            Sender.this.stopButton.setEnabled(false);
            Sender.this.sendButton.setEnabled(false);
        }
    }

    private class StartTask
    extends SwingWorker<Void, Void> {
        private StartTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            easy.startCollaboration();
            return null;
        }

        @Override
        protected void done() {
            Sender.this.startButton.setEnabled(false);
            Sender.this.stopButton.setEnabled(true);
            Sender.this.sendButton.setEnabled(true);
        }
    }
}

