/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import tecgraf.openbus.CallerChain;
import tecgraf.openbus.Connection;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOffer;

public class Utils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertyFile(String fileName) throws IOException {
        InputStream in = null;
        Properties properties = new Properties();
        File file = new File(fileName);
        in = file.exists() && !file.isDirectory() && file.canRead() ? new FileInputStream(file) : Utils.class.getResourceAsStream(fileName);
        if (in == null) {
            System.err.println(String.format("O arquivo de propriedades '%s' n\u00e3o foi encontrado", fileName));
            return properties;
        }
        try {
            properties.load(in);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                System.err.println("Ocorreu um erro ao fechar o arquivo de propriedades");
                e.printStackTrace();
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(String path) throws IOException {
        byte[] data = null;
        File file = new File(path);
        try (FileInputStream is = new FileInputStream(file);){
            int read;
            int length = (int)file.length();
            data = new byte[length];
            for (int offset = is.read(data); offset < length; offset += read) {
                read = is.read(data, offset, length - offset);
                if (read >= 0) continue;
                throw new IOException("N\u00e3o foi poss\u00edvel ler todo o arquivo");
            }
        }
        return data;
    }

    public static void setTestLogLevel(Level level) {
        Logger logger = Logger.getLogger("tecgraf.openbus.interop");
        Utils.setLogLevel(logger, level);
    }

    public static void setLibLogLevel(Level level) {
        Logger logger = Logger.getLogger("tecgraf.openbus.core");
        Utils.setLogLevel(logger, level);
    }

    public static void setLogLevel(Logger logger, Level level) {
        logger.setLevel(level);
        for (Handler h : logger.getHandlers()) {
            logger.removeHandler(h);
        }
        logger.setUseParentHandlers(false);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new LogFormatter());
        handler.setLevel(level);
        logger.addHandler(handler);
    }

    public static String chain2str(CallerChain chain) {
        StringBuffer buffer = new StringBuffer();
        for (LoginInfo loginInfo : chain.originators()) {
            buffer.append(loginInfo.entity);
            buffer.append("->");
        }
        buffer.append(chain.caller().entity);
        return buffer.toString();
    }

    public static Codec createCodec(ORB orb) throws UnknownEncoding, InvalidName {
        Object obj = orb.resolve_initial_references("CodecFactory");
        CodecFactory codecFactory = CodecFactoryHelper.narrow(obj);
        byte major = 1;
        byte minor = 2;
        Encoding encoding = new Encoding(0, major, minor);
        return codecFactory.create_codec(encoding);
    }

    public static String file2IOR(String iorfile) throws IOException {
        try (BufferedReader in = null;){
            in = new BufferedReader(new FileReader(iorfile));
            String string = in.readLine();
            return string;
        }
    }

    public static class ShutdownThread
    extends Thread {
        private ORB orb;
        private List<Connection> conns = new ArrayList<Connection>();
        private List<ServiceOffer> offers = new ArrayList<ServiceOffer>();

        public ShutdownThread(ORB orb) {
            this.orb = orb;
        }

        @Override
        public void run() {
            for (ServiceOffer offer : this.offers) {
                try {
                    offer.remove();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (Connection conn : this.conns) {
                try {
                    conn.logout();
                }
                catch (ServiceFailure e) {
                    e.printStackTrace();
                }
            }
            this.orb.shutdown(true);
            this.orb.destroy();
        }

        public void addConnection(Connection conn) {
            this.conns.add(conn);
        }

        public void addOffer(ServiceOffer offer) {
            this.offers.add(offer);
        }
    }

    public static class ORBRunThread
    extends Thread {
        private ORB orb;

        public ORBRunThread(ORB orb) {
            this.orb = orb;
        }

        @Override
        public void run() {
            this.orb.run();
        }
    }

    private static class LogFormatter
    extends Formatter {
        SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        private LogFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            String result = String.format("%s [%s] %s\n", this.time.format(record.getMillis()), record.getLevel(), record.getMessage());
            Throwable t = record.getThrown();
            return t == null ? result : result + this.getStackTrace(t);
        }

        private String getStackTrace(Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }
    }
}

