/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;

public class Configs {
    public String bushost;
    public int busport;
    public String busref;
    public String buscrt;
    public String bus2host;
    public int bus2port;
    public String bus2ref;
    public String bus2crt;
    public String admin;
    public byte[] admpsw;
    public String domain;
    public String user;
    public byte[] password;
    public String system;
    public String syskey;
    public String sharedauth;
    public Level testlog;
    public Level log;
    public String orbprops;
    public String wrongkey;
    public String wrongsystem;

    private Configs(Properties props) {
        this.bushost = props.getProperty("bus.host.name", "localhost");
        this.busport = Integer.valueOf(props.getProperty("bus.host.port", "2089"));
        this.busref = props.getProperty("bus.reference.path", "BUS01.ior");
        this.buscrt = props.getProperty("bus.certificate.path", "BUS01.crt");
        this.bus2host = props.getProperty("bus2.host.name", this.bushost);
        Integer port2 = this.busport + 1;
        this.bus2port = Integer.valueOf(props.getProperty("bus2.host.port", port2.toString()));
        this.bus2ref = props.getProperty("bus2.reference.path", "BUS02.ior");
        this.bus2crt = props.getProperty("bus2.certificate.path", "BUS02.crt");
        this.admin = props.getProperty("admin.enitiy.name", "admin");
        this.admpsw = props.getProperty("admin.password", this.admin).getBytes();
        this.domain = props.getProperty("user.password.domain", "testing");
        this.user = props.getProperty("user.entity.name", "testuser");
        this.password = props.getProperty("user.password", this.user).getBytes();
        this.system = props.getProperty("system.entity.name", "testsyst");
        this.syskey = props.getProperty("system.private.key", "testsyst.key");
        this.sharedauth = props.getProperty("system.sharedauth", "sharedauth.dat");
        this.testlog = this.parseLevelFromNumber(Integer.valueOf(props.getProperty("openbus.test.verbose", "0")));
        this.log = this.parseLevelFromNumber(Integer.valueOf(props.getProperty("openbus.log.level", "0")));
        this.orbprops = props.getProperty("jacorb.properties", "/jacorb.properties");
        this.wrongkey = props.getProperty("system.wrong.key", "wrong.key");
        this.wrongsystem = props.getProperty("system.wrong.name", "nocertsyst");
    }

    public static Configs readConfigsFile() throws IOException {
        String path = System.getenv("OPENBUS_TESTCFG");
        if (path == null) {
            path = "/demo.properties";
        }
        return new Configs(Utils.readPropertyFile(path));
    }

    private Level parseLevelFromNumber(Integer level) {
        HashMap<Integer, Level> levels = new HashMap<Integer, Level>();
        levels.put(0, Level.OFF);
        levels.put(1, Level.SEVERE);
        levels.put(2, Level.WARNING);
        levels.put(3, Level.INFO);
        levels.put(4, Level.CONFIG);
        levels.put(5, Level.FINE);
        levels.put(6, Level.FINER);
        levels.put(7, Level.FINEST);
        return (Level)levels.get(level);
    }
}

