/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.services.collaboration.easy;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA.TypeCode;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynArray;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import scs.core.IComponent;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.services.collaboration.easy.IEasyCollaboration;
import tecgraf.openbus.services.collaboration.easy.Utils;
import tecgraf.openbus.services.collaboration.v1_0.CollaborationObserver;
import tecgraf.openbus.services.collaboration.v1_0.CollaborationObserverHelper;
import tecgraf.openbus.services.collaboration.v1_0.CollaborationObserverPOA;
import tecgraf.openbus.services.collaboration.v1_0.CollaborationRegistry;
import tecgraf.openbus.services.collaboration.v1_0.CollaborationRegistryHelper;
import tecgraf.openbus.services.collaboration.v1_0.CollaborationSession;
import tecgraf.openbus.services.collaboration.v1_0.EventConsumer;
import tecgraf.openbus.services.collaboration.v1_0.EventConsumerHelper;
import tecgraf.openbus.services.collaboration.v1_0.EventConsumerPOA;
import tecgraf.openbus.services.collaboration.v1_0.SessionDoesNotExist;
import tecgraf.openbus.services.collaboration.v1_0.SessionRegistry;
import tecgraf.openbus.services.collaboration.v1_0.SessionRegistryHelper;

public class EasyCollaboration
implements IEasyCollaboration {
    private POA poa;
    private OpenBusContext context;
    private DynAnyFactory factory;
    private SessionRegistry sessions;
    private CollaborationRegistry collabs;
    private CollaborationSession theSession;
    private CollaborationObserverPOA observer;
    private EventConsumerPOA consumer;
    private byte[] observerPOAId;
    private byte[] consumerPOAId;
    private int subsId;
    private int obsId;
    private static Logger logger = Logger.getLogger(EasyCollaboration.class.getName());

    public EasyCollaboration(OpenBusContext context) {
        this.context = context;
        this.consumer = new Consumer();
        this.observer = new Observer();
    }

    public EasyCollaboration(OpenBusContext context, CollaborationObserverPOA observer) {
        this(context);
        this.observer = observer;
    }

    public EasyCollaboration(OpenBusContext context, EventConsumerPOA consumer, CollaborationObserverPOA observer) {
        this(context);
        this.consumer = consumer;
        this.observer = observer;
    }

    public CollaborationSession findCollaboration() throws ServiceFailure, SessionDoesNotExist {
        return this.getSessions().getSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CollaborationSession startCollaboration() throws ServiceFailure {
        try {
            this.factory = DynAnyFactoryHelper.narrow((Object)this.context.orb().resolve_initial_references("DynAnyFactory"));
            this.poa = POAHelper.narrow((Object)this.context.orb().resolve_initial_references("RootPOA"));
            this.poa.the_POAManager().activate();
        }
        catch (InvalidName | AdapterInactive e) {
            throw new ServiceFailure(e.getMessage());
        }
        logger.info("Starting collaboration");
        SessionRegistry sreg = this.getSessions();
        EasyCollaboration easyCollaboration = this;
        synchronized (easyCollaboration) {
            try {
                this.theSession = sreg.getSession();
                logger.info("Session retrieved: " + this.theSession);
            }
            catch (SessionDoesNotExist e) {
                logger.warning("Session not found for entity " + e.entity);
            }
            catch (Throwable t) {
                logger.severe("Unknown error: " + t.getMessage());
                throw new ServiceFailure(t.getMessage());
            }
            if (this.theSession == null) {
                CollaborationRegistry collab = this.getCollabs();
                this.theSession = collab.createCollaborationSession();
                sreg.registerSession(this.theSession);
            }
            this.activateObserver(this.poa);
            this.activateConsumer(this.poa);
        }
        return this.theSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitCollaboration() throws ServiceFailure {
        EasyCollaboration easyCollaboration = this;
        synchronized (easyCollaboration) {
            try {
                this.deactivateConsumer(this.poa);
                this.deactivateObserver(this.poa);
            }
            finally {
                this.subsId = 0;
                this.obsId = 0;
                this.theSession = null;
                this.consumerPOAId = null;
                this.observerPOAId = null;
                this.collabs = null;
                this.sessions = null;
                logger.info("Collaboration finished");
            }
        }
    }

    private void deactivateConsumer(POA poa) throws ServiceFailure {
        try {
            poa.deactivate_object(this.consumerPOAId);
        }
        catch (ObjectNotActive | WrongPolicy e) {
            logger.warning("Failed to deactivate consumer: " + e);
        }
        this.theSession.channel().unsubscribe(this.subsId);
    }

    private void deactivateObserver(POA poa) throws ServiceFailure {
        try {
            poa.deactivate_object(this.observerPOAId);
        }
        catch (ObjectNotActive | WrongPolicy e) {
            logger.warning("Failed to deactivate observer: " + e);
        }
        this.theSession.unsubscribeObserver(this.obsId);
    }

    private void activateObserver(POA poa) throws ServiceFailure {
        if (this.observerPOAId != null) {
            try {
                this.deactivateObserver(poa);
            }
            catch (Exception e) {
                logger.warning("Failed to deactivate previously activated observer: " + e.getMessage());
            }
        }
        if (this.observer != null) {
            try {
                this.observerPOAId = poa.activate_object((Servant)this.observer);
                CollaborationObserver ref = CollaborationObserverHelper.narrow(poa.id_to_reference(this.observerPOAId));
                this.obsId = this.theSession.subscribeObserver(ref);
                logger.info("Collaboration observer subscribed");
            }
            catch (ObjectNotActive | ServantAlreadyActive | WrongPolicy e) {
                throw new ServiceFailure(e.getLocalizedMessage(), "Error while collaboration observer activation");
            }
        }
    }

    private void activateConsumer(POA poa) throws ServiceFailure {
        if (this.consumerPOAId != null) {
            try {
                this.deactivateConsumer(poa);
            }
            catch (Exception e) {
                logger.warning("Failed to deactivate previously activated consumer: " + e.getMessage());
            }
        }
        if (this.consumer != null) {
            try {
                this.consumerPOAId = poa.activate_object((Servant)this.consumer);
                EventConsumer ref = EventConsumerHelper.narrow(poa.id_to_reference(this.consumerPOAId));
                this.subsId = this.theSession.channel().subscribe(ref);
                logger.info("Consumer registered");
            }
            catch (ObjectNotActive | ServantAlreadyActive | WrongPolicy e) {
                throw new ServiceFailure(e.getLocalizedMessage(), "Error while event consumer activation");
            }
        }
    }

    @Override
    public void shareDataKey(byte[] key) throws ServiceFailure {
        Any any = this.context.orb().create_any();
        OctetSeqHelper.insert((Any)any, (byte[])key);
        this.theSession.channel().push(any);
    }

    @Override
    public void shareDataKeys(List<byte[]> keys) throws ServiceFailure {
        try {
            TypeCode array_tc = this.context.orb().create_array_tc(keys.size(), OctetSeqHelper.type());
            DynArray dyn_array = (DynArray)this.factory.create_dyn_any_from_type_code(array_tc);
            Any[] elements = new Any[keys.size()];
            for (int i = 0; i < keys.size(); ++i) {
                elements[i] = this.context.orb().create_any();
                OctetSeqHelper.insert((Any)elements[i], (byte[])keys.get(i));
            }
            dyn_array.set_elements(elements);
            this.theSession.channel().push(dyn_array.to_any());
            dyn_array.destroy();
        }
        catch (InconsistentTypeCode | InvalidValue | TypeMismatch e) {
            throw new ServiceFailure(e.getMessage());
        }
    }

    @Override
    public void shareAny(Any any) throws ServiceFailure {
        this.theSession.channel().push(any);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> consumeDataKeys() {
        EasyCollaboration easyCollaboration = this;
        synchronized (easyCollaboration) {
            LinkedList<byte[]> list = new LinkedList<byte[]>();
            if (this.consumer instanceof Consumer) {
                Consumer servant = (Consumer)this.consumer;
                list.addAll(servant.keys);
                servant.keys.clear();
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Any> consumeAnys() {
        EasyCollaboration easyCollaboration = this;
        synchronized (easyCollaboration) {
            LinkedList<Any> list = new LinkedList<Any>();
            if (this.consumer instanceof Consumer) {
                Consumer servant = (Consumer)this.consumer;
                list.addAll(servant.anys);
                servant.anys.clear();
            }
            return list;
        }
    }

    private SessionRegistry getSessions() throws ServiceFailure {
        if (this.sessions == null || this.sessions._non_existent()) {
            ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("openbus.component.interface", SessionRegistryHelper.id())};
            List<ServiceOfferDesc> services = Utils.findOffer(this.context.getOfferRegistry(), serviceProperties, 1, 10, 1);
            for (ServiceOfferDesc offerDesc : services) {
                Object obj = offerDesc.service_ref.getFacet(SessionRegistryHelper.id());
                if (obj == null) continue;
                this.sessions = SessionRegistryHelper.narrow(obj);
                if (this.sessions == null) continue;
                break;
            }
        }
        return this.sessions;
    }

    private CollaborationRegistry getCollabs() throws ServiceFailure {
        if (this.collabs == null || this.collabs._non_existent()) {
            ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("openbus.component.interface", CollaborationRegistryHelper.id())};
            List<ServiceOfferDesc> services = Utils.findOffer(this.context.getOfferRegistry(), serviceProperties, 1, 10, 1);
            for (ServiceOfferDesc offerDesc : services) {
                Object obj = offerDesc.service_ref.getFacet(CollaborationRegistryHelper.id());
                if (obj == null) continue;
                this.collabs = CollaborationRegistryHelper.narrow(obj);
                if (this.collabs == null) continue;
                break;
            }
        }
        return this.collabs;
    }

    private class Observer
    extends CollaborationObserverPOA {
        private Observer() {
        }

        @Override
        public void memberAdded(String name, IComponent member) throws ServiceFailure {
            logger.info("Member added: " + name);
        }

        @Override
        public void memberRemoved(String name) throws ServiceFailure {
            logger.info("Member removed: " + name);
        }

        @Override
        public void destroyed() throws ServiceFailure {
            logger.info("Collaboration session destroyed");
        }
    }

    protected class Consumer
    extends EventConsumerPOA {
        private List<byte[]> keys = Collections.synchronizedList(new LinkedList());
        private List<Any> anys = Collections.synchronizedList(new LinkedList());

        Consumer() {
        }

        @Override
        public void push(Any event) throws ServiceFailure {
            logger.info("Received event type: " + event.type().toString());
            if (event.type().equivalent(OctetSeqHelper.type())) {
                this.keys.add(OctetSeqHelper.extract((Any)event));
            } else if (event.type().kind().value() == 20) {
                DynArray dyn_array;
                try {
                    dyn_array = (DynArray)EasyCollaboration.this.factory.create_dyn_any(event);
                }
                catch (InconsistentTypeCode e) {
                    throw new ServiceFailure(e.getMessage());
                }
                Any[] elements = dyn_array.get_elements();
                for (int i = 0; i < elements.length; ++i) {
                    if (elements[i].type().equivalent(OctetSeqHelper.type())) {
                        this.keys.add(OctetSeqHelper.extract((Any)elements[i]));
                        continue;
                    }
                    this.anys.add(elements[i]);
                }
                dyn_array.destroy();
            } else {
                this.anys.add(event);
            }
        }
    }
}

