/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.utils;

import com.google.common.collect.ArrayListMultimap;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import tecgraf.openbus.CallerChain;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OfferRegistry;
import tecgraf.openbus.RemoteOffer;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;

public class LibUtils {
    public static String chain2str(CallerChain chain) {
        StringBuilder buffer = new StringBuilder();
        for (LoginInfo loginInfo : chain.originators()) {
            buffer.append(loginInfo.entity);
            buffer.append("->");
        }
        buffer.append(chain.caller().entity);
        return buffer.toString();
    }

    public static Codec createCodec(ORB orb) throws UnknownEncoding, InvalidName {
        Object obj = orb.resolve_initial_references("CodecFactory");
        CodecFactory codecFactory = CodecFactoryHelper.narrow((Object)obj);
        byte major = 1;
        byte minor = 2;
        Encoding encoding = new Encoding(0, major, minor);
        return codecFactory.create_codec(encoding);
    }

    public static List<RemoteOffer> findOffer(OfferRegistry offers, ArrayListMultimap<String, String> search, int count, int tries, int interval) throws ServiceFailure {
        ArrayList<RemoteOffer> found = new ArrayList<RemoteOffer>();
        for (int i = 0; i < tries; ++i) {
            found.clear();
            try {
                Thread.sleep(interval * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            List services = offers.findServices(search);
            if (services.size() > 0) {
                Iterator iterator = services.iterator();
                while (iterator.hasNext()) {
                    RemoteOffer offer = (RemoteOffer)iterator.next();
                    try {
                        if (offer.service()._non_existent()) continue;
                        found.add(offer);
                    }
                    catch (Exception exception) {}
                }
            }
            if (found.size() < count) continue;
            return found;
        }
        StringBuilder buffer = new StringBuilder();
        for (RemoteOffer offer : found) {
            ArrayListMultimap props = offer.properties();
            String name = (String)props.get((java.lang.Object)"openbus.offer.entity").get(0);
            String login = (String)props.get((java.lang.Object)"openbus.offer.login").get(0);
            buffer.append(String.format("\n - %s (%s)", name, login));
        }
        String msg = String.format("n\u00e3o foi poss\u00edvel encontrar ofertas: found (%d) expected(%d) tries (%d) time (%d)%s", found.size(), count, tries, tries * interval, buffer.toString());
        throw new IllegalStateException(msg);
    }

    public static String file2IOR(String iorfile) throws IOException {
        try (BufferedReader in = null;){
            in = new BufferedReader(new FileReader(iorfile));
            String string = in.readLine();
            return string;
        }
    }

    public static class ShutdownThread
    extends Thread {
        private ORB orb;
        private List<Connection> conns = new ArrayList<Connection>();
        private List<RemoteOffer> offers = new ArrayList<RemoteOffer>();

        public ShutdownThread(ORB orb) {
            this.orb = orb;
        }

        @Override
        public void run() {
            for (RemoteOffer offer : this.offers) {
                try {
                    offer.remove();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (Connection conn : this.conns) {
                try {
                    conn.logout();
                }
                catch (ServiceFailure e) {
                    e.printStackTrace();
                }
            }
            this.orb.shutdown(true);
            this.orb.destroy();
        }

        public void addConnetion(Connection conn) {
            this.conns.add(conn);
        }

        public void addOffer(RemoteOffer offer) {
            this.offers.add(offer);
        }
    }

    public static class ORBRunThread
    extends Thread {
        private ORB orb;

        public ORBRunThread(ORB orb) {
            this.orb = orb;
        }

        @Override
        public void run() {
            this.orb.run();
        }
    }
}

