/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Utils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertyFile(String fileName) throws IOException {
        InputStream in = null;
        Properties properties = new Properties();
        File file = new File(fileName);
        in = file.exists() && !file.isDirectory() && file.canRead() ? new FileInputStream(file) : Utils.class.getResourceAsStream(fileName);
        if (in == null) {
            System.err.println(String.format("O arquivo de propriedades '%s' n\u00e3o foi encontrado", fileName));
            return properties;
        }
        try {
            properties.load(in);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                System.err.println("Ocorreu um erro ao fechar o arquivo de propriedades");
                e.printStackTrace();
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(String path) throws IOException {
        byte[] data = null;
        File file = new File(path);
        try (FileInputStream is = new FileInputStream(file);){
            int read;
            int length = (int)file.length();
            data = new byte[length];
            for (int offset = is.read(data); offset < length; offset += read) {
                read = is.read(data, offset, length - offset);
                if (read >= 0) continue;
                throw new IOException("N\u00e3o foi poss\u00edvel ler todo o arquivo");
            }
        }
        return data;
    }

    public static void setTestLogLevel(Level level) {
        Logger logger = Logger.getLogger("tecgraf.openbus.interop");
        Utils.setLogLevel(logger, level);
    }

    public static void setLibLogLevel(Level level) {
        Logger logger = Logger.getLogger("tecgraf.openbus.core");
        Utils.setLogLevel(logger, level);
    }

    public static void setLogLevel(Logger logger, Level level) {
        logger.setLevel(level);
        for (Handler h : logger.getHandlers()) {
            logger.removeHandler(h);
        }
        logger.setUseParentHandlers(false);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new LogFormatter());
        handler.setLevel(level);
        logger.addHandler(handler);
    }

    private static class LogFormatter
    extends Formatter {
        SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        private LogFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            String result = String.format("%s [%s] %s\n", this.time.format(record.getMillis()), record.getLevel(), record.getMessage());
            Throwable t = record.getThrown();
            return t == null ? result : result + this.getStackTrace(t);
        }

        private String getStackTrace(Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }
    }
}

