/**
 * $Id: ClientSGAFileParameterImpl.java 131406 2012-07-24 19:21:30Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

/**
 * A classe <code>ClientSGAFileParameterImpl</code> implementa um valutype
 * <code>ClientSGAFileParameter</code>
 * 
 * @author Tecgraf
 */
public class ClientSGAFileParameterImpl extends ClientSGAFileParameter {

  /**
   * Separador de valores da representao textual de um ClientSGAFileParameter.
   */
  private static final String VALUE_SEPARATOR = ",";

  /**
   * Separador de itens da representao textual de um ClientSGAFileParameter.
   */
  private static final String ITEM_SEPARATOR = ";";

  /**
   * Construtor padro.
   */
  public ClientSGAFileParameterImpl() {
    this.sgaName = "";
    this.separator = "";
    this.files = new ClientSGAFile[0];
  }

  /**
   * Construtor que recebe o valor do parmetro.
   * 
   * @param sgaName nome do SGA
   * @param separator separador de diretrio
   * @param files lista de arquivos
   */
  public ClientSGAFileParameterImpl(String sgaName, String separator,
    ClientSGAFile[] files) {
    this.sgaName = sgaName;
    this.separator = separator;
    this.files = files;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String convertToText() {
    // Representao textual do parmetro ClientSGAFileParameter:
    // sgaName,separator;v11,v12,v13,v14,v15,v16,v17,v18;v21,v22,v23,v24,v25,v26,v27,v28
    StringBuffer sb = new StringBuffer();
    sb.append(this.sgaName);
    sb.append(VALUE_SEPARATOR);
    sb.append(this.separator);
    sb.append(ITEM_SEPARATOR);

    for (ClientSGAFile file : files) {
      sb.append(file.dir);
      sb.append(VALUE_SEPARATOR);
      sb.append(file.symlink);
      sb.append(VALUE_SEPARATOR);
      sb.append(file.canRead);
      sb.append(VALUE_SEPARATOR);
      sb.append(file.canWrite);
      sb.append(VALUE_SEPARATOR);
      sb.append(file.canExecute);
      sb.append(VALUE_SEPARATOR);
      sb.append(file.size);
      sb.append(VALUE_SEPARATOR);
      sb.append(file.path);
      sb.append(VALUE_SEPARATOR);
      sb.append(file.linkPath);
      sb.append(ITEM_SEPARATOR);
    }

    return sb.toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getIDLType() {
    return ClientSGAFileParameterHelper.id();
  }
}