/**
 * $Id: DoubleListParameterImpl.java 131406 2012-07-24 19:21:30Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

import tecgraf.openbus.algorithmservice.v1_1.ConversionToTextException;

/**
 * A classe <code>DoubleListParameterImpl</code> implementa um valutype
 * <code>DoubleListParameter</code>
 * 
 * @author Tecgraf
 */
public class DoubleListParameterImpl extends DoubleListParameter {

  /**
   * Construtor padro.
   */
  public DoubleListParameterImpl() {
    this.valueList = new DoubleParameterImpl[0];
  }

  /**
   * Construtor que recebe o valor do parmetro.
   * 
   * @param valueList lista de valores
   */
  public DoubleListParameterImpl(double[] valueList) {
    this.valueList = new DoubleParameterImpl[valueList.length];
    for (int i = 0; i < valueList.length; i++) {
      this.valueList[i] = new DoubleParameterImpl(valueList[i]);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String convertToText() throws ConversionToTextException {
    return ListParameter.convertListToText(valueList);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getIDLType() {
    return DoubleListParameterHelper.id();
  }
}